/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.editor2;

import gnu.trove.procedure.TObjectProcedure;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.Activator;
import org.simantics.scl.ui.editor2.Messages;

public class SCLModuleSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "SCLModuleSelectionDialogSettings";

    public SCLModuleSelectionDialog(Shell shell) {
        super(shell, false);
        this.setTitle(Messages.SCLModuleSelectionDialog_ChooseSCLModule);
        this.setSelectionHistory(new ModuleSelectionHistory());
        this.setListLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                return (String)element;
            }
        });
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getInstance().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = Activator.getInstance().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredItemsSelectionDialog.ItemsFilter(this){
            {
                String patternText = this.getPattern();
                this.patternMatcher = new SearchPattern();
                if (patternText != null && patternText.length() > 0) {
                    this.patternMatcher.setPattern(patternText);
                } else {
                    this.patternMatcher.setPattern("*");
                }
            }

            public boolean matchItem(Object item) {
                String text = item.toString();
                if (this.getPattern().contains("/")) {
                    return this.matches(text);
                }
                int p = text.lastIndexOf(47);
                if (p >= 0) {
                    text = text.substring(p + 1);
                }
                return this.matches(text);
            }

            public boolean isConsistentItem(Object item) {
                return true;
            }
        };
    }

    protected Comparator getItemsComparator() {
        return new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String a = (String)arg0;
                String b = (String)arg1;
                return a.compareTo(b);
            }
        };
    }

    protected void fillContentProvider(final FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, final FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        progressMonitor.beginTask(Messages.SCLModuleSelectionDialog_Searching, 1);
        SCLOsgi.SOURCE_REPOSITORY.forAllModules((TObjectProcedure)new TObjectProcedure<String>(){

            public boolean execute(String moduleName) {
                contentProvider.add((Object)moduleName, itemsFilter);
                return true;
            }
        });
        progressMonitor.worked(1);
        progressMonitor.done();
    }

    public String getElementName(Object item) {
        return item.toString();
    }

    private class ModuleSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private ModuleSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento element) {
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento element) {
        }
    }
}

