/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.editor2;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.ui.browser.SCLDefinitionSelectionDialog;
import org.simantics.scl.ui.editor2.SCLModuleEditor2;
import org.simantics.scl.ui.editor2.StandardSCLModuleEditorInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSCLDefinition
extends AbstractHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSCLDefinition.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        SCLValue value;
        SCLDefinitionSelectionDialog dialog = new SCLDefinitionSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        if (dialog.open() == 0 && (value = (SCLValue)dialog.getFirstResult()) != null) {
            OpenSCLDefinition.scheduleOpenDefinition(value.getName().module, value.definitionLocation);
        }
        return null;
    }

    public static void openDefinition(SCLValue value) {
        OpenSCLDefinition.openDefinition(value.getName().module, value.definitionLocation);
    }

    public static Runnable openDefinition(String moduleName, long location) {
        return () -> {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page == null) {
                return;
            }
            StandardSCLModuleEditorInput input = new StandardSCLModuleEditorInput(moduleName);
            try {
                IEditorPart editor = page.openEditor((IEditorInput)input, "org.simantics.scl.ui.editor2");
                if (editor instanceof SCLModuleEditor2 && location != 9223372034707292160L) {
                    SCLModuleEditor2 sclEditor = (SCLModuleEditor2)editor;
                    int begin = Locations.beginOf((long)location);
                    int end = Locations.endOf((long)location);
                    sclEditor.selectAndReveal(begin, end - begin);
                }
            }
            catch (PartInitException e) {
                LOGGER.error("Failed to open SCL module editor", (Throwable)e);
            }
        };
    }

    public static void scheduleOpenDefinition(String moduleName, long location) {
        Display.getCurrent().asyncExec(OpenSCLDefinition.openDefinition(moduleName, location));
    }
}

