/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.editor2;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.ui.editor.completion.SCLTextEditorEnvironment;
import org.simantics.scl.ui.editor2.SCLModuleEditor2;
import org.simantics.scl.ui.editor2.SCLModuleEditorInput;
import org.simantics.scl.ui.search.SCLSearchQuery;

public class FindSCLSearchAction
extends AbstractHandler {
    private static final String SYMBOL_CHARS = "!$%&*+/<=>?@\\^|-:~.";

    private static boolean isIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c) || c == '.';
    }

    private static String extractIdentifierAt(String text, int caretPos) {
        int startPos = caretPos;
        while (startPos > 0 && FindSCLSearchAction.isIdentifierPart(text.charAt(startPos - 1))) {
            --startPos;
        }
        int endPos = caretPos;
        while (endPos < text.length() && FindSCLSearchAction.isIdentifierPart(text.charAt(endPos))) {
            ++endPos;
        }
        return text.substring(startPos, endPos);
    }

    private static boolean isSymbolPart(char c) {
        int i = 0;
        while (i < SYMBOL_CHARS.length()) {
            if (SYMBOL_CHARS.charAt(i) == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String extractSymbolAt(String text, int caretPos) {
        int startPos = caretPos;
        while (startPos > 0 && FindSCLSearchAction.isSymbolPart(text.charAt(startPos - 1))) {
            --startPos;
        }
        int endPos = caretPos;
        while (endPos < text.length() && FindSCLSearchAction.isSymbolPart(text.charAt(endPos))) {
            ++endPos;
        }
        return text.substring(startPos, endPos);
    }

    public static String extractIdentifierOrSymbolAt(String text, int caretPos) {
        String result = FindSCLSearchAction.extractIdentifierAt(text, caretPos);
        if (!result.isEmpty()) {
            return result;
        }
        return FindSCLSearchAction.extractSymbolAt(text, caretPos);
    }

    private static String extractLineAt(String text, int caretPos) {
        int startPos = caretPos;
        while (startPos > 0 && !FindSCLSearchAction.isNewline(text.charAt(startPos - 1))) {
            --startPos;
        }
        int endPos = caretPos;
        while (endPos < text.length() && !FindSCLSearchAction.isNewline(text.charAt(endPos))) {
            ++endPos;
        }
        return text.substring(startPos, endPos);
    }

    private static boolean isNewline(char c) {
        return c == '\n' || c == '\r';
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        int caretOffset;
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (!(editor instanceof SCLModuleEditor2)) {
            return null;
        }
        SCLModuleEditor2 moduleEditor = (SCLModuleEditor2)editor;
        StyledText styledText = (StyledText)moduleEditor.getAdapter(Control.class);
        String text = styledText.getText();
        String identifierAtCaret = FindSCLSearchAction.extractIdentifierOrSymbolAt(text, caretOffset = styledText.getCaretOffset());
        if (identifierAtCaret.isEmpty()) {
            return null;
        }
        SCLModuleEditorInput input = (SCLModuleEditorInput)moduleEditor.getEditorInput();
        String localModuleName = input.getModuleName();
        SCLTextEditorEnvironment editorEnvironment = moduleEditor.getSCLTextEditorEnvironment();
        editorEnvironment.updateEnvironment(moduleEditor.getDocument());
        SCLValue value = editorEnvironment.getValue(identifierAtCaret);
        Name name = value == null ? Name.create((String)localModuleName, (String)identifierAtCaret) : value.getName();
        SCLSearchQuery query = new SCLSearchQuery(name, localModuleName);
        NewSearchUI.runQueryInBackground((ISearchQuery)query);
        return null;
    }
}

