/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.editor.completion;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.compilation.EnvironmentOfModule;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.environment.AmbiguousNameException;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.internal.parsing.exceptions.SCLSyntaxErrorException;
import org.simantics.scl.compiler.internal.parsing.parser.SCLParserImpl;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.InvalidModulePathException;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.ModuleUtils;
import org.simantics.scl.compiler.module.repository.ImportFailureException;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.editor.completion.SCLCompletionProposal;
import org.simantics.scl.ui.editor.completion.SCLCompletionType;

public class SCLTextEditorEnvironment {
    private String moduleName;
    private SCLCompletionProposal[] proposalCache = new SCLCompletionProposal[0];
    private List<SCLCompletionProposal> moduleProposalCache = new ArrayList<SCLCompletionProposal>(0);
    private Environment env;
    private List<ImportDeclaration> cachedImports = new ArrayList<ImportDeclaration>();
    private boolean cacheUpdated = false;
    private static final Comparator<SCLCompletionProposal> COMPARATOR = new Comparator<SCLCompletionProposal>(){

        @Override
        public int compare(SCLCompletionProposal prop1, SCLCompletionProposal prop2) {
            if (prop1.isPrivate() && !prop2.isPrivate()) {
                return -1;
            }
            if (!prop1.isPrivate() && prop2.isPrivate()) {
                return 1;
            }
            return prop1.getName().compareTo(prop2.getName());
        }
    };

    public SCLTextEditorEnvironment(String moduleName) {
        this.moduleName = moduleName;
    }

    public void updateModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void updateEnvironment(IDocument document) {
        String contents = document.get();
        contents = contents.replaceAll("(?s)\"\"\".*?\"\"\"", "\"\"");
        contents = contents.replaceAll("(?s)/\\*.*?\\*/", "");
        String[] lines = contents.split("\\R+");
        ArrayList<ImportDeclaration> imports = new ArrayList<ImportDeclaration>();
        imports.add(new ImportDeclaration("StandardLibrary", ""));
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).startsWith("import ") || line.startsWith("include ")) {
                SCLParserImpl parser = new SCLParserImpl((Reader)new StringReader(line));
                try {
                    ImportDeclaration importDecl = (ImportDeclaration)parser.parseImport();
                    imports.add(importDecl);
                }
                catch (SCLSyntaxErrorException sCLSyntaxErrorException) {}
            }
            ++n2;
        }
        if (!(imports = this.processRelativeImports(imports)).equals(this.cachedImports)) {
            this.cachedImports = imports;
            try {
                this.env = SCLOsgi.MODULE_REPOSITORY.createEnvironment(this.cachedImports.toArray(new ImportDeclaration[this.cachedImports.size()]), null);
                Failable module = SCLOsgi.MODULE_REPOSITORY.getModule(this.moduleName);
                if (module.didSucceed()) {
                    this.env = new EnvironmentOfModule(this.env, (Module)module.getResult());
                }
            }
            catch (ImportFailureException importFailureException) {}
        }
    }

    public ICompletionProposal[] getCompletionProposals(String prefix, int offset) {
        int p = prefix.lastIndexOf(46);
        String lastPart = p == -1 ? prefix : prefix.substring(p + 1);
        ArrayList<SCLCompletionProposal> proposals = new ArrayList<SCLCompletionProposal>();
        for (SCLValue value : Environments.findValuesForPrefix((Environment)this.env, (String)prefix)) {
            Name name = value.getName();
            if (!name.module.equals(this.moduleName) && value.isPrivate() || name.name.contains("$") && Character.isLetter(name.name.charAt(0))) continue;
            proposals.add(new SCLCompletionProposal(value, offset - lastPart.length(), lastPart));
        }
        for (TCon type : Environments.findTypesForPrefix((Environment)this.env, (String)prefix)) {
            proposals.add(new SCLCompletionProposal(type.name, type.module, SCLCompletionType.TYPE, offset - lastPart.length(), lastPart));
        }
        if (!prefix.contains(".")) {
            for (ImportDeclaration decl : this.cachedImports) {
                if (decl.localName == null || decl.localName.isEmpty() || !decl.localName.toLowerCase().startsWith(prefix.toLowerCase())) continue;
                proposals.add(new SCLCompletionProposal(decl.localName, decl.moduleName, SCLCompletionType.CONST, offset - prefix.length(), prefix));
            }
        }
        Collections.sort(proposals, COMPARATOR);
        this.moduleProposalCache = proposals;
        this.proposalCache = this.moduleProposalCache.toArray(new SCLCompletionProposal[this.moduleProposalCache.size()]);
        return this.proposalCache;
    }

    private ArrayList<ImportDeclaration> processRelativeImports(List<ImportDeclaration> relativeImports) {
        ArrayList<ImportDeclaration> absoluteImports = new ArrayList<ImportDeclaration>(relativeImports.size());
        for (ImportDeclaration relativeImport : relativeImports) {
            try {
                String absoluteModuleName = ModuleUtils.resolveAbsolutePath((String)this.moduleName, (String)relativeImport.moduleName);
                absoluteImports.add(new ImportDeclaration(relativeImport.location, absoluteModuleName, relativeImport.localName, relativeImport.reexport, relativeImport.spec));
            }
            catch (InvalidModulePathException invalidModulePathException) {}
        }
        return absoluteImports;
    }

    public SCLValue getValue(String text) {
        try {
            return Environments.getValue((Environment)this.env, (String)text);
        }
        catch (AmbiguousNameException ambiguousNameException) {
            return null;
        }
    }

    public String getHoverInfo(String text) {
        SCLValue value = this.getValue(text);
        if (value != null) {
            return value.getDocumentation();
        }
        return null;
    }
}

