/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.editor;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.simantics.scl.ui.Activator;
import org.simantics.scl.ui.editor.completion.SCLCompletionAssistProcessor;
import org.simantics.scl.ui.editor.completion.SCLTextEditorEnvironment;
import org.simantics.scl.ui.editor2.SCLPresentationReconciler;

public class SCLSourceViewerConfigurationNew
extends SourceViewerConfiguration {
    public static final char[] CONTENT_ASSIST_AUTO_CHARS = new char[]{'.'};
    ResourceManager resourceManager;
    IPreferenceStore preferenceStore;
    private SCLTextEditorEnvironment sclTextEditorEnvironment;
    private ISourceViewer sourceViewer;
    private static final IInformationControlCreator CREATOR = new IInformationControlCreator(){

        public IInformationControl createInformationControl(Shell parent) {
            return new DefaultInformationControl(parent);
        }
    };

    public SCLSourceViewerConfigurationNew(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.preferenceStore = EditorsUI.getPreferenceStore();
        this.sclTextEditorEnvironment = new SCLTextEditorEnvironment("");
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type"};
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        if (this.preferenceStore == null) {
            return super.getTabWidth(sourceViewer);
        }
        return this.preferenceStore.getInt("tabWidth");
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        String[] indentPrefixes = this.getIndentPrefixesForTab(this.getTabWidth(sourceViewer));
        if (indentPrefixes == null) {
            return null;
        }
        int length = indentPrefixes.length;
        if (length > 2) {
            String first = indentPrefixes[0];
            indentPrefixes[0] = indentPrefixes[length - 2];
            indentPrefixes[length - 2] = first;
        }
        return indentPrefixes;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        SCLPresentationReconciler reconciler = new SCLPresentationReconciler(this.resourceManager);
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        this.sourceViewer = sourceViewer;
        return reconciler;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new DefaultTextHover(sourceViewer);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover();
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.enableColoredLabels(true);
        assistant.setStatusLineVisible(true);
        assistant.enableAutoActivation(true);
        assistant.enableAutoInsert(true);
        assistant.setContentAssistProcessor((IContentAssistProcessor)new SCLCompletionAssistProcessor(this.sclTextEditorEnvironment), "__dftl_partition_content_type");
        assistant.setInformationControlCreator(CREATOR);
        assistant.setRestoreCompletionProposalSize(Activator.getInstance().getDialogSettings());
        return assistant;
    }

    public void updateCompletionAssistModuleName(String moduleName) {
        this.sclTextEditorEnvironment.updateModuleName(moduleName);
    }

    public SCLTextEditorEnvironment getSclTextEditorEnvironment() {
        return this.sclTextEditorEnvironment;
    }

    /*
     * WARNING - void declaration
     */
    public void fontChanged(FontDescriptor fd) {
        ISourceViewer iSourceViewer;
        ISourceViewer sv = this.sourceViewer;
        if (sv != null && (iSourceViewer = sv) instanceof ISourceViewerExtension2) {
            void sve2;
            ISourceViewerExtension2 iSourceViewerExtension2 = (ISourceViewerExtension2)iSourceViewer;
            ISourceViewerExtension2 cfr_ignored_0 = (ISourceViewerExtension2)iSourceViewer;
            sve2.unconfigure();
            sv.configure((SourceViewerConfiguration)this);
        }
    }
}

