/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.editor;

import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;
import org.simantics.scl.ui.editor.ColorManager;
import org.simantics.scl.ui.editor.ReplaceTabsBySpaces;
import org.simantics.scl.ui.info.SCLInfo;

public class SCLSourceViewerConfiguration
extends SourceViewerConfiguration {
    ColorManager colorManager;

    public SCLSourceViewerConfiguration(ColorManager colorManager) {
        this.colorManager = colorManager;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning("SCL_PARTIONING");
        Token string = new Token((Object)new TextAttribute(this.colorManager.get(new RGB(42, 0, 255))));
        RuleBasedScanner scanner = new RuleBasedScanner();
        scanner.setDefaultReturnToken((IToken)string);
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
        reconciler.setRepairer((IPresentationRepairer)dr, "STRING");
        reconciler.setDamager((IPresentationDamager)dr, "STRING");
        Token comment = new Token((Object)new TextAttribute(this.colorManager.get(new RGB(63, 127, 95))));
        scanner = new RuleBasedScanner();
        scanner.setDefaultReturnToken((IToken)comment);
        dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
        reconciler.setRepairer((IPresentationRepairer)dr, "COMMENT");
        reconciler.setDamager((IPresentationDamager)dr, "COMMENT");
        DefaultDamagerRepairer dr2 = new DefaultDamagerRepairer(this.getSclTokenScanner());
        reconciler.setRepairer((IPresentationRepairer)dr2, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr2, "__dftl_partition_content_type");
        return reconciler;
    }

    private ITokenScanner getSclTokenScanner() {
        RuleBasedScanner scanner = new RuleBasedScanner();
        Token reserved = new Token((Object)new TextAttribute(this.colorManager.get(new RGB(127, 0, 85)), null, 1));
        WordRule reservedWord = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }

            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c);
            }
        }, (IToken)new Token((Object)new TextAttribute(this.colorManager.get(new RGB(0, 0, 0)))));
        String[] stringArray = SCLInfo.RESERVED_WORDS;
        int n = SCLInfo.RESERVED_WORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            reservedWord.addWord(word, (IToken)reserved);
            ++n2;
        }
        IRule[] rules = new IRule[]{reservedWord, new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char c) {
                return Character.isWhitespace(c);
            }
        })};
        scanner.setRules(rules);
        return scanner;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new ReplaceTabsBySpaces(), new DefaultIndentLineAutoEditStrategy()};
    }
}

