/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.assist;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.ui.assist.SCLContentProposal;

public class SCLContentProposalProvider
implements IContentProposalProvider {
    private final CommandSession session;

    public SCLContentProposalProvider(CommandSession session) {
        this.session = session;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        int startPos = SCLContentProposalProvider.getPrefixStartPos(contents, position);
        String prefix = contents.substring(startPos, position);
        prefix.length();
        int namespaceLength = prefix.indexOf(46);
        namespaceLength = namespaceLength < 0 ? 0 : ++namespaceLength;
        List values = Environments.findValuesForPrefix((Environment)this.session.getRuntimeEnvironment().getEnvironment(), (String)prefix);
        ArrayList<SCLContentProposal> proposals = new ArrayList<SCLContentProposal>();
        for (SCLValue value : values) {
            if (value.isPrivate() || value.getName().name.contains("$") && Character.isLetter(value.getName().name.charAt(0))) continue;
            proposals.add(new SCLContentProposal(value));
        }
        prefix = prefix.toLowerCase();
        for (Map.Entry entry : this.session.localNamesForContentProposals().entrySet()) {
            if (!((String)entry.getKey()).toLowerCase().startsWith(prefix)) continue;
            proposals.add(new SCLContentProposal((String)entry.getKey(), "LocalEnvironment", (Type)entry.getValue()));
        }
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }

    private static int getPrefixStartPos(String contents, int position) {
        int pos = position;
        while (pos > 0) {
            char c = contents.charAt(pos - 1);
            if (!Character.isJavaIdentifierPart(c) && c != '.') break;
            --pos;
        }
        return pos;
    }
}

