package org.simantics.scl.ui.issues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.simantics.scl.osgi.issues.SCLIssueFactoryProvider;
import org.simantics.scl.osgi.issues.SCLIssueProviderFactory.SCLIssueProvider;
import org.simantics.scl.osgi.issues.SCLIssuesTableEntry;

public class SCLIssuesContentProvider implements IStructuredContentProvider {

    public static final int MAX_ISSUE_COUNT = 1000;

    private Viewer viewer;
    boolean disposed = false;
    private AtomicBoolean refreshInProgress = new AtomicBoolean(false);
    private List<SCLIssueProvider> issueProviders = new ArrayList<>();

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (!issueProviders.isEmpty()) {
            issueProviders.forEach(p -> p.dispose());
            issueProviders.clear();
        }
        if(newInput != null) {
            issueProviders = SCLIssueFactoryProvider.getSCLIssueProviderFactories().stream().map(f -> f.getSCLIssueProvider()).collect(Collectors.toList());
            issueProviders.forEach(p -> p.listenIssues(() -> refresh()));
        }
    }

    private void refresh() {
        if(!refreshInProgress.compareAndSet(false, true))
            return;
        if(viewer == null)
            return;
        Control control = viewer.getControl();
        if(control.isDisposed() || disposed)
            return;
        control.getDisplay().asyncExec(new Runnable() {
            @Override
            public void run() {
                if(control.isDisposed() || disposed)
                    return;
                refreshInProgress.set(false);
                viewer.refresh();
            }
        });
    }

    public void dispose() {
        if(this.disposed)
            return;
        issueProviders.forEach(p -> p.dispose());
        issueProviders.clear();
        this.disposed = true;
    }

    @Override
    public Object[] getElements(Object inputElement) {
        ArrayList<SCLIssuesTableEntry> result = new ArrayList<>();
        issueProviders.forEach(p -> result.addAll(p.getIssues()));
        Collections.sort(result);
        return result.toArray();
    }

}
