package org.simantics.scl.ui.imports.internal;

import gnu.trove.procedure.TObjectProcedure;

import java.util.Comparator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.Activator;

public class SCLModuleSelectionDialog extends FilteredItemsSelectionDialog {

    private static final String SCL_MODULE_SELECTION_DIALOG = "SCL_MODULE_SELECTION_DIALOG"; //$NON-NLS-1$
    
    public SCLModuleSelectionDialog(Shell shell) {
        super(shell, true);
    }

    @Override
    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    @Override
    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = org.simantics.scl.ui.Activator.getInstance()
                .getDialogSettings().getSection(SCL_MODULE_SELECTION_DIALOG);
        if (settings == null)
            settings = Activator.getInstance()
            .getDialogSettings().addNewSection(SCL_MODULE_SELECTION_DIALOG);
        return settings;
    }

    @Override
    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    @Override
    protected ItemsFilter createFilter() {
        return new ItemsFilter() {
            {
                String patternText = getPattern();
                patternMatcher = new SearchPattern();
                if(patternText != null && patternText.length() > 0)
                    patternMatcher.setPattern(patternText);
                else 
                    patternMatcher.setPattern("*"); //$NON-NLS-1$
            }
            
            @Override
            public boolean matchItem(Object item) {
                if(getPattern().indexOf('/') > 0)
                    return matches((String)item);
                else {
                    for(String part : ((String)item).split("/")) //$NON-NLS-1$
                        if(matches(part))
                            return true;
                    return false;
                }
            }

            @Override
            public boolean isConsistentItem(Object item) {
                return true;
            }
            
        };
    }

    Comparator<String> comparator = new Comparator<String>() {
        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    };
    
    @SuppressWarnings("rawtypes")
    @Override
    protected Comparator getItemsComparator() {
        return comparator;
    }

    @Override
    protected void fillContentProvider(final AbstractContentProvider contentProvider,
            final ItemsFilter itemsFilter, IProgressMonitor progressMonitor)
            throws CoreException {
        SCLOsgi.SOURCE_REPOSITORY.forAllModules(new TObjectProcedure<String>() {
            @Override
            public boolean execute(String module) {
                contentProvider.add(module, itemsFilter);
                return true;
            }
        });
        if(progressMonitor != null)
            progressMonitor.done();
    }

    @Override
    public String getElementName(Object item) {
        return (String)item;
    }

}
