package org.simantics.scl.ui.imports.internal;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Shell;
import org.simantics.scl.compiler.commands.CommandSessionImportEntry;
import org.simantics.scl.ui.imports.ImportModulesAction;

public class BasicImportModulesAction extends ImportModulesAction {
    
    public static final BasicImportModulesAction INSTANCE = new BasicImportModulesAction();
            
    public BasicImportModulesAction() {
        super(Messages.BasicImportModulesAction_AddModules, 0.0);
    }

    @Override
    public boolean editImports(Shell shell, ArrayList<CommandSessionImportEntry> imports) {
        SCLModuleSelectionDialog dialog = new SCLModuleSelectionDialog(shell);
        dialog.setTitle(Messages.BasicImportModulesAction_AddModules);
        if(dialog.open() == Dialog.OK) {
            for(Object r : dialog.getResult()) {
                new CommandSessionImportEntry((String)r, "", true).addTo(imports); //$NON-NLS-1$
            }
            return true;
        }
        else
            return false;
    }

}
