package org.simantics.scl.ui.editor2;

import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;

public class SCLPartitionScanner extends RuleBasedPartitionScanner {
    public static final String SCL_COMMENT = "COMMENT"; //$NON-NLS-1$
    public static final String SCL_STRING = "STRING"; //$NON-NLS-1$
    
    public static final IToken COMMENT_TOKEN = new Token(SCL_COMMENT);
    public static final IToken STRING_TOKEN = new Token(SCL_STRING);
    
    public static final String[] PARTITION_TYPES = new String[] {
            SCL_COMMENT,
            SCL_STRING
    };
    
    public SCLPartitionScanner() {
        super();

        setPredicateRules(new IPredicateRule[] {
                new EndOfLineRule("//", COMMENT_TOKEN), //$NON-NLS-1$
                new MultiLineRule("\"\"\"", "\"\"\"", STRING_TOKEN, (char) 0, true), //$NON-NLS-1$ //$NON-NLS-2$
                new SingleLineRule("\"", "\"", STRING_TOKEN, '\\'), //$NON-NLS-1$ //$NON-NLS-2$
                new MultiLineRule("/*", "*/", COMMENT_TOKEN, (char) 0, true), //$NON-NLS-1$ //$NON-NLS-2$
        });
    }
}
