package org.simantics.scl.ui.editor2;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSCLModule extends AbstractHandler {

    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSCLModule.class);

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        SCLModuleSelectionDialog dialog = new SCLModuleSelectionDialog(
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        if(dialog.open() == SCLModuleSelectionDialog.OK) {
            String moduleName = (String)dialog.getFirstResult();
            scheduleOpenModule(moduleName);
        }
        return null;
    }

    public static Runnable openModule(String moduleName) {
        return () -> {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if(page == null)
                return;
            SCLModuleEditorInput input = new StandardSCLModuleEditorInput(moduleName);
            try {
                page.openEditor(input, "org.simantics.scl.ui.editor2"); //$NON-NLS-1$
            } catch (PartInitException e) {
                LOGGER.error("Could not open module {} ", moduleName, e); //$NON-NLS-1$
            }
        };
    }

    public static void scheduleOpenModule(String moduleName) {
        Display.getCurrent().asyncExec(openModule(moduleName));
    }

}
