package org.simantics.scl.ui.editor2;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;

public class DebugPartionTokenScanner implements IPartitionTokenScanner {
    IPartitionTokenScanner base;

    public DebugPartionTokenScanner(IPartitionTokenScanner base) {
        this.base = base;
    }

    @Override
    public void setRange(IDocument document, int offset, int length) {
        System.out.println(">>> setRange(" + offset + ", " + length + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
        base.setRange(document, offset, length);
    }

    @Override
    public IToken nextToken() {
        IToken result = base.nextToken();
        System.out.println(">>> nextToken -> " + result + " " + result.getData()); //$NON-NLS-1$ //$NON-NLS-2$
        return result;
    }

    @Override
    public int getTokenOffset() {
        int result = base.getTokenOffset();
        System.out.println(">>> getTokenOffset -> " + result); //$NON-NLS-1$
        return result;
    }

    @Override
    public int getTokenLength() {
        int result = base.getTokenLength();
        System.out.println(">>> getTokenLength -> " + result); //$NON-NLS-1$
        return result;
    }

    @Override
    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        System.out.println(">>> setPartialRange(" + offset + ", " + length + ", " + contentType + ", " + partitionOffset + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
        base.setPartialRange(document, offset, length, contentType, partitionOffset);
    }
    
    
}
