package org.simantics.scl.ui.editor;

import java.util.List;

import org.simantics.scl.compiler.errors.CompilationError;

public class TextAndErrors {

	public final String text;
	public final CompilationError[] errors;

	public TextAndErrors(String text, CompilationError[] errors) {
		this.text = text;
		this.errors = errors;
	}
	
	public static TextAndErrors createTextAndErrors(String text, List<CompilationError> errors) {
		return new TextAndErrors(text, errors.toArray(new CompilationError[errors.size()]));
	}
	
}
