package org.simantics.scl.ui.editor;

import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;

public class SCLDocumentSetup implements IDocumentSetupParticipant {
    
    public static final String COMMENT = "COMMENT"; //$NON-NLS-1$
    public static final String STRING = "STRING"; //$NON-NLS-1$
    
    public static final String[] PARTITION_TYPES = new String[] {
        COMMENT, STRING
    };
    
    public static final String SCL_PARTIONING = "SCL_PARTIONING"; //$NON-NLS-1$
    
    
    @Override
    public void setup(final IDocument document) {
        if(document instanceof IDocumentExtension3) {
            RuleBasedPartitionScanner scanner = new RuleBasedPartitionScanner();
            scanner.setPredicateRules(new IPredicateRule[] {
                    new MultiLineRule("/*", "*/", new Token(COMMENT)), //$NON-NLS-1$ //$NON-NLS-2$
                    new EndOfLineRule("//", new Token(COMMENT)), //$NON-NLS-1$
                    new MultiLineRule("\"\"\"", "\"\"\"", new Token(STRING), '\\'), //$NON-NLS-1$ //$NON-NLS-2$
                    new PatternRule("\"", "\"", new Token(STRING), '\\', true), //$NON-NLS-1$ //$NON-NLS-2$
            });
            IDocumentPartitioner partitioner = new FastPartitioner(scanner, PARTITION_TYPES);
            ((IDocumentExtension3)document).setDocumentPartitioner(SCL_PARTIONING, partitioner);
            partitioner.connect(document);
        }
    }

}
