package org.simantics.scl.ui.editor;

import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;

public class MatchingBracketsEditStrategy implements IAutoEditStrategy {

	char justAddedClosingBracket = (char)0;
	
	public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
		if (c.length == 0 && c.text != null) {
			if(c.text.equals("(")) { //$NON-NLS-1$
				c.text = "()"; //$NON-NLS-1$
				justAddedClosingBracket = ')';
			}
			else if(c.text.equals("[")) { //$NON-NLS-1$
				c.text = "[]"; //$NON-NLS-1$
				justAddedClosingBracket = ']';
			}
			else {
				if(c.text.length() == 1 && c.text.charAt(0) == justAddedClosingBracket) {
					c.text = ""; //$NON-NLS-1$
					c.shiftsCaret = false;
					c.caretOffset = c.offset+1;
				}
				justAddedClosingBracket = (char)0;
				return;
			}
			
			// Puts caret between brackets
			c.caretOffset = c.offset+1;
			c.shiftsCaret = false;			
		}		
		else
			justAddedClosingBracket = (char)0;
	}
	
}
