package org.simantics.scl.ui.console;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import org.simantics.scl.compiler.commands.SCLConsoleListener;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;

/**
 * @author Tuukka Lehtonen
 * @since 1.31.0
 */
public class SCLScriptConsoleView extends ViewPart {

    private SCLConsole console;

    @Override
    public void createPartControl(Composite parent) {
        this.console = new SCLConsole(parent, SWT.NONE,
                AbstractCommandConsole.HIDE_INPUT | SCLConsole.EXCLUDE_CONTRIBUTED_LISTENERS);

        IToolBarManager toolBarManager = getViewSite().getActionBars().getToolBarManager();
        Action clearAction = ConsoleActions.createClearAction(console);
        toolBarManager.add(clearAction);

        console.addListener(new SCLConsoleListener() {
            @Override
            public void consoleIsNotEmptyAnymore() {
                clearAction.setEnabled(true);
            }
        });

        toolBarManager.update(true);
    }

    @Override
    public void setFocus() {
        console.setFocus();
    }

    @Override
    public void dispose() {
        super.dispose();
        console.dispose();
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == SCLReportingHandler.class)
            return (T) console.getHandler();
        if (adapter == SCLConsole.class)
            return (T) console;
        return super.getAdapter(adapter);
    }

}
