package org.simantics.scl.ui.console;

import org.eclipse.jface.action.Action;
import org.simantics.scl.ui.Activator;

/**
 * @author Tuukka Lehtonen
 * @since 1.31.0
 */
class ConsoleActions {

    public static Action createInterruptAction(SCLConsole console) {
        Action interruptAction = new Action(Messages.ConsoleActions_InterruptCurrentCommand,
                Activator.imageDescriptorFromPlugin("org.simantics.scl.ui", "icons/stop.png")) { //$NON-NLS-1$ //$NON-NLS-2$
            @Override
            public void run() {
                console.interruptCurrentCommands();
            }
        };
        interruptAction.setDisabledImageDescriptor(
                Activator.imageDescriptorFromPlugin("org.simantics.scl.ui", "icons/stop_disabled.png")); //$NON-NLS-1$ //$NON-NLS-2$
        interruptAction.setEnabled(false);
        return interruptAction;
    }

    public static Action createClearAction(SCLConsole console) {
        Action clearAction = new Action(Messages.ConsoleActions_ClearConsole,
                Activator.imageDescriptorFromPlugin("org.simantics.scl.ui", "icons/clear_console.png")) { //$NON-NLS-1$ //$NON-NLS-2$
            @Override
            public void run() {
                setEnabled(false);
                console.clear();
            }
        };
        clearAction.setDisabledImageDescriptor(
                Activator.imageDescriptorFromPlugin("org.simantics.scl.ui", "icons/clear_console_disabled.png")); //$NON-NLS-1$ //$NON-NLS-2$
        clearAction.setEnabled(false);
        return clearAction;
    }

}
