package org.simantics.scl.ui;

import java.util.Hashtable;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.simantics.scl.ui.imports.ImportModulesAction;
import org.simantics.scl.ui.imports.internal.BasicImportModulesAction;
import org.simantics.scl.ui.imports.internal.ExternalImportModulesAction;
import org.simantics.scl.ui.imports.internal.ManualImportModulesAction;

public class Activator extends AbstractUIPlugin {

    public static final String PLUGIN_ID = "org.simantics.scl.ui"; //$NON-NLS-1$

    private static Activator INSTANCE;
    
    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
        
        Hashtable<String,Object> properties = new Hashtable<String,Object>();
        context.registerService(ImportModulesAction.class, BasicImportModulesAction.INSTANCE, properties);
        context.registerService(ImportModulesAction.class, ManualImportModulesAction.INSTANCE, properties);
        context.registerService(ImportModulesAction.class, ExternalImportModulesAction.INSTANCE, properties);
    }
    
    @Override
    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put("arrow_left", Activator.imageDescriptorFromPlugin("org.simantics.scl.ui", "icons/arrow_left.png") ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
        reg.put("arrow_right", Activator.imageDescriptorFromPlugin("org.simantics.scl.ui", "icons/arrow_right.png") ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
        reg.put("arrow_refresh", Activator.imageDescriptorFromPlugin("org.simantics.scl.ui", "icons/arrow_refresh.png") ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
        reg.put("find", Activator.imageDescriptorFromPlugin("org.simantics.scl.ui", "icons/find.png") ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
        reg.put("disk", Activator.imageDescriptorFromPlugin("org.simantics.scl.ui", "icons/disk.png") ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
        reg.put("error", Activator.imageDescriptorFromPlugin("org.simantics.scl.ui", "icons/error.png") ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
        reg.put("import_error", Activator.imageDescriptorFromPlugin("org.simantics.scl.ui", "icons/import_error.png") ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
        reg.put("warning", Activator.imageDescriptorFromPlugin("org.simantics.scl.ui", "icons/warning.png") ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
    }
    
    @Override
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static Activator getInstance() {
        return INSTANCE;
    }
    
}
