/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.unification;

import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.scl.runtime.unification.RuntimeUnificationException;
import org.simantics.scl.runtime.unification.UCons;
import org.simantics.scl.runtime.unification.UPending;
import org.simantics.scl.runtime.unification.UVar;

public class Unification {
    public static Object canonical(Object a) {
        if (a instanceof UVar) {
            UVar ua = (UVar)a;
            if (ua.bound) {
                ua.ref = Unification.canonical(ua.ref);
                return ua.ref;
            }
            return a;
        }
        return a;
    }

    public static void unify(Object a, Object b) {
        if ((a = Unification.canonical(a)) == (b = Unification.canonical(b))) {
            return;
        }
        if (a instanceof UVar) {
            ((UVar)a).setRef(b);
            return;
        }
        if (b instanceof UVar) {
            ((UVar)b).setRef(a);
            return;
        }
        if (a instanceof UPending) {
            ((UPending)a).checkAgains(b);
            return;
        }
        if (b instanceof UPending) {
            ((UPending)b).checkAgains(a);
            return;
        }
        if (a instanceof UCons) {
            UCons ua = (UCons)a;
            if (b instanceof UCons) {
                UCons ub = (UCons)b;
                if (ua.tag.id != ub.tag.id) {
                    throw new RuntimeUnificationException();
                }
                Unification.unifyTuple(ua.components, ub.components);
                ua.components = ub.components;
            } else {
                Object bComponents = ua.tag.destructor.apply(b);
                Unification.unifyTuple(ua.components, bComponents);
                ua.components = bComponents;
            }
        } else if (b instanceof UCons) {
            UCons ub = (UCons)b;
            Object aComponents = ub.tag.destructor.apply(a);
            Unification.unifyTuple(aComponents, ub.components);
            ub.components = aComponents;
        } else if (a == null ? b != null : !a.equals(b)) {
            throw new RuntimeUnificationException();
        }
    }

    public static void unifyTuple(Object a, Object b) {
        if (a instanceof Tuple) {
            Tuple ta = (Tuple)a;
            Tuple tb = (Tuple)b;
            int length = ta.length();
            int i = 0;
            while (i < length) {
                Unification.unify(ta.get(i), tb.get(i));
                ++i;
            }
        } else {
            Unification.unify(a, b);
        }
    }

    public static Object extractWithDefault(Function def, Object uni) {
        if (uni instanceof UVar) {
            UVar var = (UVar)uni;
            if (var.bound) {
                var.ref = Unification.extractWithDefault(def, var.ref);
                return var.ref;
            }
            var.bound = true;
            var.ref = def.apply(Tuple0.INSTANCE);
            return var.ref;
        }
        if (uni instanceof UCons) {
            UCons cons = (UCons)uni;
            return cons.tag.constructor.apply(cons.components);
        }
        if (uni instanceof UPending) {
            UPending pending = (UPending)uni;
            return pending.force();
        }
        return uni;
    }
}

