/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.minigraph;

import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.minigraph.Statement;
import org.simantics.scl.runtime.tuple.Tuple0;

public class Minigraph {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    TIntObjectHashMap<TIntHashSet> predicatesPerSubject = new TIntObjectHashMap();
    TLongObjectHashMap<Object> objectsPerSubjectPredicate = new TLongObjectHashMap();
    TIntObjectHashMap<String> idToUri = new TIntObjectHashMap();
    TObjectIntHashMap<String> uriToId = new TObjectIntHashMap(10, 0.5f, -1);
    TIntObjectHashMap<String> values = new TIntObjectHashMap();
    int resourceCount = 0;
    int InverseOf;

    private static long combine(int a, int b) {
        return (long)a << 32 | (long)b;
    }

    private static int[] toArray(Object obj) {
        if (obj == null) {
            return EMPTY_INT_ARRAY;
        }
        if (obj instanceof Integer) {
            return new int[]{(Integer)obj};
        }
        return ((TIntHashSet)obj).toArray();
    }

    private static void add(TIntObjectHashMap<TIntHashSet> map, int key, int value) {
        TIntHashSet set = (TIntHashSet)map.get(key);
        if (set == null) {
            set = new TIntHashSet();
            map.put(key, (Object)set);
        }
        set.add(value);
    }

    private static void remove(TIntObjectHashMap<TIntHashSet> map, int key, int value) {
        TIntHashSet set = (TIntHashSet)map.get(key);
        if (set != null) {
            set.remove(value);
        }
    }

    private static void add(TLongObjectHashMap<Object> map, long key, int value) {
        Object obj = map.get(key);
        if (obj == null) {
            map.put(key, (Object)value);
        } else if (obj instanceof Integer) {
            TIntHashSet set = new TIntHashSet();
            set.add(((Integer)obj).intValue());
            set.add(value);
            map.put(key, (Object)set);
        } else {
            ((TIntHashSet)obj).add(value);
        }
    }

    private static boolean remove(TLongObjectHashMap<Object> map, long key, int value) {
        Object obj = map.get(key);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Integer) {
            if (value != (Integer)obj) {
                return false;
            }
            map.put(key, null);
            return true;
        }
        TIntHashSet set = (TIntHashSet)obj;
        if (!set.remove(value)) {
            return false;
        }
        if (set.size() == 1) {
            map.put(key, (Object)set.iterator().next());
        }
        return false;
    }

    public int blank() {
        return this.resourceCount++;
    }

    public int getResource(String uri) {
        int id = this.uriToId.get((Object)uri);
        if (id >= 0) {
            return id;
        }
        this.idToUri.put(this.resourceCount, (Object)uri);
        this.uriToId.put((Object)uri, this.resourceCount);
        return this.resourceCount++;
    }

    public String getUri(int r) {
        String uri = (String)this.idToUri.get(r);
        if (uri != null) {
            return uri;
        }
        return "#" + r;
    }

    public void rawClaim(int s, int p, int o) {
        Minigraph.add(this.predicatesPerSubject, s, p);
        Minigraph.add(this.objectsPerSubjectPredicate, Minigraph.combine(s, p), o);
    }

    public void claim(int s, int p, int o) {
        this.rawClaim(s, p, o);
        int inv = this.getPossibleObject(p, this.InverseOf);
        if (inv >= 0) {
            this.rawClaim(o, inv, s);
        }
    }

    public void rawDeny(int s, int p, int o) {
        if (Minigraph.remove(this.objectsPerSubjectPredicate, Minigraph.combine(s, p), o)) {
            Minigraph.remove(this.predicatesPerSubject, s, p);
        }
    }

    public void deny(int s, int p, int o) {
        this.rawDeny(s, p, o);
        int inv = this.getPossibleObject(p, this.InverseOf);
        if (inv >= 0) {
            this.rawDeny(o, inv, s);
        }
    }

    public int[] getObjects(int s, int p) {
        return Minigraph.toArray(this.objectsPerSubjectPredicate.get(Minigraph.combine(s, p)));
    }

    public int[] getSubjects(int o, int p) {
        int inv = this.getPossibleObject(p, this.InverseOf);
        if (inv >= 0) {
            return this.getObjects(o, inv);
        }
        return EMPTY_INT_ARRAY;
    }

    public int getPossibleObject(int s, int p) {
        Object obj = this.objectsPerSubjectPredicate.get(Minigraph.combine(s, p));
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return -1;
    }

    public boolean hasStatement(int s, int p, int o) {
        Object obj = this.objectsPerSubjectPredicate.get(Minigraph.combine(s, p));
        if (obj == null) {
            return false;
        }
        if (obj instanceof Integer) {
            return o == (Integer)obj;
        }
        return ((TIntHashSet)obj).contains(o);
    }

    public List<Statement> getStatements(final int s) {
        TIntHashSet preds = (TIntHashSet)this.predicatesPerSubject.get(s);
        if (preds == null) {
            return Collections.emptyList();
        }
        final ArrayList<Statement> statements = new ArrayList<Statement>();
        preds.forEach(new TIntProcedure(){

            public boolean execute(final int p) {
                Object obj = Minigraph.this.objectsPerSubjectPredicate.get(Minigraph.combine(s, p));
                if (obj instanceof Integer) {
                    statements.add(new Statement(s, p, (Integer)obj));
                } else {
                    ((TIntHashSet)obj).forEach(new TIntProcedure(){

                        public boolean execute(int o) {
                            statements.add(new Statement(s, p, o));
                            return true;
                        }
                    });
                }
                return true;
            }
        });
        return statements;
    }

    public void setValue(int s, String value) {
        this.values.put(s, (Object)value);
    }

    private void initializeLayer0() {
        this.InverseOf = this.getResource("Layer0/InverseOf");
        this.rawClaim(this.InverseOf, this.InverseOf, this.InverseOf);
    }

    public Minigraph() {
        this.initializeLayer0();
    }

    public static void main(String[] args) {
        Minigraph g = new Minigraph();
        g.claim(10, g.InverseOf, 11);
        g.claim(12, g.InverseOf, 13);
        g.claim(1, 10, 2);
        g.claim(1, 10, 3);
        g.claim(1, 12, 4);
        System.out.println(g.getStatements(2));
    }

    public static Object withGraph(Function f) {
        Object oldGraph = SCLContext.getCurrent().put("graph", new Minigraph());
        try {
            Object r = f.apply(Tuple0.INSTANCE);
            return r;
        }
        finally {
            SCLContext.getCurrent().put("graph", oldGraph);
        }
    }
}

