package org.simantics.scl.runtime.reporting;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * <p>An interface that is used to handle printing commands from SCL 
 * such as Prelude.print. This interface is typically stored to 
 * SCLContext with name {@link SCLReportingHandler#REPORTING_HANDLER}.
 * 
 * <p>A convenient way to call the methods of this interface in 
 * arbitrary evaluation context is to use class {@link SCLReporting}
 * 
 * @author Hannu Niemist&ouml;
 */
public interface SCLReportingHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(SCLReportingHandler.class);
    public static final String REPORTING_HANDLER = "reportingHandler";
    
    public void print(String text);
    public void printError(String error);
    public void printCommand(String command);
    public void didWork(double amount);

    public static final SCLReportingHandler DEFAULT = new AbstractSCLReportingHandler() {
        @Override
        public void print(String text) {
            LOGGER.info(text);
        }

        @Override
        public void printError(String error) {
            LOGGER.error(error);
        }
    };
    
    public static final SCLReportingHandler DEFAULT_WITHOUT_ECHO = new AbstractSCLReportingHandler() {
        @Override
        public void print(String text) {
            LOGGER.info(text);
        }

        @Override
        public void printError(String error) {
            LOGGER.error(error);
        }

        @Override
        public void printCommand(String command) {
        }
    };
    
    public static final SCLReportingHandler SYSOUT = new AbstractSCLReportingHandler() {
        @Override
        public void print(String text) {
            System.out.println(text);
        }

        @Override
        public void printError(String error) {
            LOGGER.error(error);
        }
    };
    
    public static final SCLReportingHandler SYSOUT_WITHOUT_ECHO = new AbstractSCLReportingHandler() {
        @Override
        public void print(String text) {
            System.out.println(text);
        }

        @Override
        public void printError(String error) {
            LOGGER.error(error);
        }

        @Override
        public void printCommand(String command) {
        }
    };
}
