package org.simantics.scl.runtime.profiling;

public class BranchPoint {
    public static final BranchPoint[] EMPTY_ARRAY = new BranchPoint[0];
    
    private final long location;
    private final int codeSize;
    private final BranchPoint[] children;
    
    public int visitCounter;

    public BranchPoint(long location, int codeSize, BranchPoint[] children) {
        this.location = location;
        this.codeSize = codeSize;
        this.children = children;
    }
    
    public void resetVisitCountersRecursively() {
        visitCounter = 0;
        for(BranchPoint branchPoint : getChildren())
            branchPoint.resetVisitCountersRecursively();
    }

    public long getLocation() {
        return location;
    }

    public int getCodeSize() {
        return codeSize;
    }
    
    public int getVisitCounter() {
        return visitCounter;
    }

    public void incrementVisitCounter(int amount) {
        visitCounter = visitCounter + amount;
    }

    public BranchPoint[] getChildren() {
        return children;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BP[visitCounter=").append(visitCounter).append(", codeSize=").append(codeSize).append(", location=").append(location);
        if (children.length > 0)
            sb.append(", children=").append(children.length);
        sb.append("]");
        return sb.toString();
    }

}
