package org.simantics.scl.runtime.procedure;

import java.util.UUID;

import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.scl.runtime.tuple.Tuple0;


public class Procedures {
    public static boolean isInterrupted() {
        return Thread.currentThread().isInterrupted();
    }
    
    public static void checkInterrupted() throws InterruptedException {
        if(Thread.interrupted())
            throw new InterruptedException();
    }
    
    public static String generateUID() {
        return UUID.randomUUID().toString();
    }
    
    private static Function runProc = new FunctionImpl1() {
        @Override
        public Object apply(Object f) {
            return ((Function)f).apply(Tuple0.INSTANCE);
        }
    };
    
    public static Function runProc() {
        return runProc;
    }
    
    public static Object catch_(Class<?> exceptionClass, Function expression, Function handler) throws Throwable {
        try {
            return expression.apply(Tuple0.INSTANCE);
        } catch(Throwable e) {
            if(exceptionClass.isAssignableFrom(e.getClass()))
                return handler.apply(e);
            else
                throw e;
        }
    }
}
