package org.simantics.scl.runtime.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class FileIO {

	public static void moveFile(File source, File target) throws IOException {
		Files.move(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
	}
	
    public static void copyFile(File source, File target) throws IOException {
		Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void syncFile(File file) throws IOException {
    	try (RandomAccessFile raf = new RandomAccessFile(file, "rw")) {
			raf.getFD().sync();
		}
    }
    
    public static File createTempDirectory(String prefix, File parent) throws IOException {
    	if (parent != null) {
    		return Files.createTempDirectory(parent.toPath(), prefix).toFile();
    	} else {
    		return Files.createTempDirectory(prefix).toFile();
    	}
    }
}
