package org.simantics.scl.runtime.chr;

import java.util.Arrays;

import org.simantics.scl.runtime.reporting.SCLReporting;

public abstract class CHRPriorityFactContainer extends CHRPriority {
    private static final boolean CLEANUP_ENABLED = true;
    private static final int INITIAL_FACT_ARRAY_SIZE = 4;
    
    private CHRFact[] facts = new CHRFact[INITIAL_FACT_ARRAY_SIZE];
    private int size;

    public CHRPriorityFactContainer(int priority) {
        super(priority);
    }

    public boolean isEmpty() {
        return size == 0;
    }

    public void addFact(CHRContext context, CHRFact item) {
        //SCLReporting.print("added " + item + " to " + this);
        ensureInContext(context);
        if(size == facts.length)
            increaseCapacity();
        facts[size++] = item;
    }
    
    private void increaseCapacity() {
        if(CLEANUP_ENABLED) {
            // Cleanup dead facts
            int j=0;
            for(int i=0;i<size;++i) {
                CHRFact fact = facts[i];
                if(fact.id >= 0)
                    facts[j++] = fact;
            }
            size = j;
        }
        
        // Resize if necessary
        if(size >= facts.length*3/4)
            facts = Arrays.copyOf(facts, size*2);
    }

    @Override
    public void activate(CHRContext context) {
        while(size > 0) {
            --size;
            CHRFact fact = facts[size];
            facts[size] = null;
            if(fact.id >= 0)
                activate(context, fact);
        }
    }

    protected abstract void activate(CHRContext context, CHRFact fact);
}
