/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.types.util;

public enum Polarity {
    NO_POLARITY("?"),
    POSITIVE("+"),
    NEGATIVE("-"),
    BIPOLAR("=");

    private final String symbol;
    private Polarity flipped;
    private Polarity[] combi = new Polarity[4];

    static {
        int ia = 0;
        while (ia < 4) {
            Polarity a = Polarity.values()[ia];
            a.flipped = Polarity.values()[(ia & 1) << 1 | (ia & 2) >> 1];
            int ib = 0;
            while (ib < 4) {
                a.combi[ib] = Polarity.values()[ia | ib];
                ++ib;
            }
            ++ia;
        }
    }

    private Polarity(String symbol) {
        this.symbol = symbol;
    }

    public Polarity flip() {
        return this.flipped;
    }

    public Polarity add(Polarity other) {
        return this.combi[other.ordinal()];
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean isPositive() {
        return (this.ordinal() & 1) != 0;
    }

    public boolean isNegative() {
        return (this.ordinal() & 2) != 0;
    }
}

