/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.types;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.internal.types.HashCodeUtils;
import org.simantics.scl.compiler.internal.types.TypeHashCodeContext;
import org.simantics.scl.compiler.internal.types.ast.TConAst;
import org.simantics.scl.compiler.internal.types.ast.TypeAst;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.Polarity;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public class TUnion
extends Type {
    public final Type[] effects;

    public TUnion(Type ... effects) {
        Type[] typeArray = effects;
        int n = effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            if (effect == null) {
                throw new InternalCompilerError();
            }
            ++n2;
        }
        this.effects = effects;
    }

    @Override
    public Type replace(TVar var, Type replacement) {
        int i = 0;
        while (i < this.effects.length) {
            Type effect = this.effects[i];
            Type newEffect = effect.replace(var, replacement);
            if (newEffect != effect) {
                Type[] newEffects = new Type[this.effects.length];
                int j = 0;
                while (j < i) {
                    newEffects[j] = this.effects[j];
                    ++j;
                }
                newEffects[i] = newEffect;
                j = i + 1;
                while (j < this.effects.length) {
                    newEffects[j] = this.effects[j].replace(var, replacement);
                    ++j;
                }
                return new TUnion(newEffects);
            }
            ++i;
        }
        return this;
    }

    @Override
    public TypeAst toTypeAst(TypeUnparsingContext context) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.effects.length) {
            if (i > 0) {
                b.append(",");
            }
            b.append(this.effects[i].toString(context));
            ++i;
        }
        return new TConAst(b.toString());
    }

    @Override
    public void toName(TypeUnparsingContext context, StringBuilder b) {
        boolean first = true;
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            if (first) {
                first = false;
            } else {
                b.append('_');
            }
            effect.toName(context, b);
            ++n2;
        }
    }

    @Override
    public void updateHashCode(TypeHashCodeContext context) {
        context.append(-1617985681);
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            effect.updateHashCode(context);
            ++n2;
        }
    }

    @Override
    public void collectFreeVars(ArrayList<TVar> vars) {
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            effect.collectFreeVars(vars);
            ++n2;
        }
    }

    @Override
    public void collectMetaVars(ArrayList<TMetaVar> vars) {
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            effect.collectMetaVars(vars);
            ++n2;
        }
    }

    @Override
    public void collectMetaVars(THashSet<TMetaVar> vars) {
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            effect.collectMetaVars(vars);
            ++n2;
        }
    }

    @Override
    public boolean isGround() {
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            if (!effect.isGround()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean containsMetaVars() {
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            if (effect.containsMetaVars()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public int getClassId() {
        return 7;
    }

    @Override
    public boolean contains(TMetaVar other) {
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            if (type.contains(other)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Type convertMetaVarsToVars() {
        int i = 0;
        while (i < this.effects.length) {
            this.effects[i] = this.effects[i].convertMetaVarsToVars();
            ++i;
        }
        return this;
    }

    @Override
    public boolean isMinimal() {
        return this.effects.length == 0;
    }

    @Override
    public boolean isMaximal() {
        return false;
    }

    @Override
    public void addPolarity(Polarity polarity) {
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            effect.addPolarity(polarity);
            ++n2;
        }
    }

    @Override
    public void collectEffectMetaVars(ArrayList<TMetaVar> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void collectConcreteEffects(ArrayList<TCon> concreteEffects) {
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            effect.collectConcreteEffects(concreteEffects);
            ++n2;
        }
    }

    @Override
    public Type head() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Type copySkeleton(THashMap<TMetaVar, TMetaVar> metaVarMap) {
        return Types.NO_EFFECTS;
    }

    @Override
    public int hashCode(int hash) {
        int sum = UNION_HASH;
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            sum += effect.hashCode(0);
            ++n2;
        }
        return HashCodeUtils.updateWithPreprocessedValue(hash, sum);
    }

    @Override
    public int hashCode(int hash, TVar[] boundVars) {
        int sum = UNION_HASH;
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            sum += effect.hashCode(0, boundVars);
            ++n2;
        }
        return HashCodeUtils.updateWithPreprocessedValue(hash, sum);
    }

    @Override
    public int skeletonHashCode(int hash) {
        int sum = UNION_HASH;
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            sum += effect.skeletonHashCode(0);
            ++n2;
        }
        return HashCodeUtils.updateWithPreprocessedValue(hash, sum);
    }

    @Override
    public int skeletonHashCode(int hash, TVar[] boundVars) {
        int sum = UNION_HASH;
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            sum += effect.skeletonHashCode(0, boundVars);
            ++n2;
        }
        return HashCodeUtils.updateWithPreprocessedValue(hash, sum);
    }

    @Override
    public boolean equalsCanonical(Type other) {
        if (this == other) {
            return true;
        }
        if (!other.getClass().equals(TUnion.class)) {
            return false;
        }
        TUnion union = (TUnion)other;
        int length = this.effects.length;
        if (length != union.effects.length) {
            return false;
        }
        if (length == 0) {
            return true;
        }
        int i = 0;
        while (i < length) {
            this.effects[i] = this.effects[i].canonical();
            union.effects[i] = union.effects[i].canonical();
            ++i;
        }
        if (length == 2) {
            if (this.effects[0].equalsCanonical(union.effects[0])) {
                return this.effects[1].equalsCanonical(union.effects[1]);
            }
            return this.effects[0].equalsCanonical(union.effects[1]) && this.effects[1].equalsCanonical(union.effects[0]);
        }
        i = 0;
        while (i < length) {
            block11: {
                Type effect = this.effects[i];
                int j = i;
                while (j < length) {
                    if (effect.equalsCanonical(union.effects[j])) {
                        if (j > i) {
                            effect = union.effects[i];
                            union.effects[i] = union.effects[j];
                            union.effects[j] = effect;
                        }
                        break block11;
                    }
                    ++j;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Kind getKind(Environment context) {
        return Kinds.EFFECT;
    }

    @Override
    public Type[] skeletonCanonicalChildren() {
        return EMPTY_ARRAY;
    }

    protected Object readResolve() {
        if (this.effects.length == 0) {
            return Types.NO_EFFECTS;
        }
        return this;
    }
}

