/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.source.repository;

import gnu.trove.procedure.TObjectProcedure;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.source.repository.BuiltinModuleSourceRepository;
import org.simantics.scl.compiler.source.repository.ClassModuleSourceRepository;
import org.simantics.scl.compiler.source.repository.FileModuleSourceRepository;
import org.simantics.scl.compiler.source.repository.ModuleBrowsingUtil;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;
import org.simantics.scl.runtime.SCLContext;

public class SourceRepositories {
    public static final ModuleSourceRepository BUILTIN_SOURCE_REPOSITORY = new BuiltinModuleSourceRepository();
    public static final ModuleSourceRepository PRELUDE_SOURCE_REPOSITORY = SourceRepositories.createPreludeSourceEnvironment();

    private static ModuleSourceRepository createPreludeSourceEnvironment() {
        try {
            File directory = SourceRepositories.getPreludeDirectory();
            if (directory != null) {
                return new FileModuleSourceRepository(directory, SourceRepositories.class.getClassLoader()){

                    @Override
                    protected ImportDeclaration[] getBuiltinImports() {
                        return ImportDeclaration.ONLY_BUILTINS;
                    }
                };
            }
            return new ClassModuleSourceRepository((Class)SCLContext.class, SourceRepositories.class.getClassLoader(), "/scl"){

                @Override
                protected ImportDeclaration[] getBuiltinImports() {
                    return ImportDeclaration.ONLY_BUILTINS;
                }
            };
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static File getPreludeDirectory() throws IOException {
        URL url = SCLContext.class.getResource(".");
        if (url == null) {
            return null;
        }
        File file = ModuleBrowsingUtil.toFile(url);
        if (file == null) {
            return null;
        }
        File preludeDir = new File(file, "../../../../scl");
        if (preludeDir.exists()) {
            return preludeDir.getCanonicalFile();
        }
        preludeDir = new File(file, "../../../../../scl");
        if (preludeDir.exists()) {
            return preludeDir.getCanonicalFile();
        }
        return null;
    }

    public static List<String> getModuleNames(ModuleSourceRepository repository) {
        final ArrayList<String> result = new ArrayList<String>();
        repository.forAllModules(new TObjectProcedure<String>(){

            public boolean execute(String moduleName) {
                result.add(moduleName);
                return true;
            }
        });
        return result;
    }
}

