/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.runtime;

import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.runtime.ExpressionClassLoader;
import org.simantics.scl.compiler.runtime.MutableClassLoader;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.compiler.runtime.RuntimeModule;

public class RuntimeEnvironmentImpl
implements RuntimeEnvironment {
    private final Environment environment;
    private final THashMap<String, RuntimeModule> runtimeModuleMap;
    private final ClassLoader parentClassLoader;
    private MutableClassLoader classLoader;

    public RuntimeEnvironmentImpl(Environment environment, ClassLoader parentClassLoader, THashMap<String, RuntimeModule> runtimeModuleMap) {
        this.environment = environment;
        this.parentClassLoader = parentClassLoader;
        this.runtimeModuleMap = runtimeModuleMap;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public RuntimeModule getRuntimeModule(String name) {
        return (RuntimeModule)this.runtimeModuleMap.get((Object)name);
    }

    @Override
    public synchronized MutableClassLoader getMutableClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = new ExpressionClassLoader(this.parentClassLoader, this.runtimeModuleMap, "Expression");
        }
        return this.classLoader;
    }

    @Override
    public Collection<RuntimeModule> getRuntimeModules() {
        return this.runtimeModuleMap.values();
    }
}

