/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parser.regexp.automata;

import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TIntIntProcedure;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.parser.regexp.automata.Automata;
import org.simantics.scl.compiler.parser.regexp.automata.DFA;

public class NFA
implements Automata {
    private ArrayList<State> states = new ArrayList();
    private int initialState;

    @Override
    public int size() {
        return this.states.size();
    }

    @Override
    public void setInitialState(int initialState) {
        this.initialState = initialState;
    }

    @Override
    public int getInitialState() {
        return this.initialState;
    }

    @Override
    public int newState() {
        int id = this.states.size();
        this.states.add(new State());
        return id;
    }

    @Override
    public void setAccepts(int id, boolean accepts) {
        this.states.get((int)id).accepts = accepts;
    }

    @Override
    public boolean getAccepts(int id) {
        return this.states.get((int)id).accepts;
    }

    @Override
    public void addTransition(int source, int symbol, int target) {
        this.states.get(source).addTransition(symbol, target);
    }

    @Override
    public void forEachTransition(int source, final TIntIntProcedure proc) {
        this.states.get((int)source).transitions.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntArrayList>(){

            public boolean execute(int a, TIntArrayList b) {
                int i = 0;
                while (i < b.size()) {
                    if (!proc.execute(a, b.get(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        });
    }

    public void addEpsilonTransition(int source, int target) {
        this.states.get(source).addEpsilonTransition(target);
    }

    public void forEachEpsilonTransition(int source, TIntProcedure proc) {
        this.states.get((int)source).epsilonTransitions.forEach(proc);
    }

    private TIntArrayList closure(final TIntHashSet stateSet) {
        final TIntArrayList result = new TIntArrayList((TIntCollection)stateSet);
        TIntProcedure proc = new TIntProcedure(){

            public boolean execute(int value) {
                if (stateSet.add(value)) {
                    result.add(value);
                }
                return true;
            }
        };
        int i = 0;
        while (i < result.size()) {
            this.forEachEpsilonTransition(result.get(i), proc);
            ++i;
        }
        result.sort();
        return result;
    }

    public DFA determinize() {
        final DFA aut = new DFA();
        final ArrayList<TIntArrayList> stack = new ArrayList<TIntArrayList>();
        final TObjectIntHashMap map = new TObjectIntHashMap();
        TIntHashSet initialSet = new TIntHashSet(4);
        initialSet.add(this.getInitialState());
        TIntArrayList stateList = this.closure(initialSet);
        int stateId = aut.newState();
        map.put((Object)stateList, stateId);
        aut.setInitialState(stateId);
        stack.add(stateList);
        block0: while (!stack.isEmpty()) {
            int s;
            TIntArrayList curList = (TIntArrayList)stack.remove(stack.size() - 1);
            int[] stateArray = curList.toArray();
            final int id = map.get((Object)curList);
            final TIntObjectHashMap transitions = new TIntObjectHashMap();
            TIntIntProcedure proc = new TIntIntProcedure(){

                public boolean execute(int symbol, int b) {
                    TIntHashSet set = (TIntHashSet)transitions.get(symbol);
                    if (set == null) {
                        set = new TIntHashSet();
                        transitions.put(symbol, (Object)set);
                    }
                    set.add(b);
                    return true;
                }
            };
            int[] nArray = stateArray;
            int n = stateArray.length;
            int n2 = 0;
            while (n2 < n) {
                s = nArray[n2];
                this.forEachTransition(s, proc);
                ++n2;
            }
            transitions.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntHashSet>(){

                public boolean execute(int symbol, TIntHashSet b) {
                    TIntArrayList stateList = NFA.this.closure(b);
                    if (map.containsKey((Object)stateList)) {
                        aut.addTransition(id, symbol, map.get((Object)stateList));
                    } else {
                        int stateId = aut.newState();
                        map.put((Object)stateList, stateId);
                        stack.add(stateList);
                        aut.addTransition(id, symbol, stateId);
                    }
                    return true;
                }
            });
            nArray = stateArray;
            n = stateArray.length;
            n2 = 0;
            while (n2 < n) {
                s = nArray[n2];
                if (this.getAccepts(s)) {
                    aut.setAccepts(id, true);
                    continue block0;
                }
                ++n2;
            }
        }
        return aut;
    }

    private static class State {
        TIntObjectHashMap<TIntArrayList> transitions = new TIntObjectHashMap();
        TIntArrayList epsilonTransitions = new TIntArrayList();
        boolean accepts;

        private State() {
        }

        private void addTransition(int symbol, int target) {
            TIntArrayList l = (TIntArrayList)this.transitions.get(symbol);
            if (l == null) {
                l = new TIntArrayList();
                l.add(target);
                this.transitions.put(symbol, (Object)l);
            } else if (!l.contains(target)) {
                l.add(target);
            }
        }

        private void addEpsilonTransition(int target) {
            if (!this.epsilonTransitions.contains(target)) {
                this.epsilonTransitions.add(target);
            }
        }
    }
}

