/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parser.regexp.automata;

import gnu.trove.TByteCollection;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TByteArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.procedure.TIntIntProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.parser.regexp.RAtom;
import org.simantics.scl.compiler.parser.regexp.Regexp;
import org.simantics.scl.compiler.parser.regexp.automata.Automata;

public class DFA
implements Automata {
    private ArrayList<TIntIntHashMap> transitions = new ArrayList();
    private TByteArrayList accepts = new TByteArrayList();
    private int initialState;

    @Override
    public int newState() {
        int stateId = this.transitions.size();
        this.transitions.add(new TIntIntHashMap(10, 0.5f, 0, -1));
        this.accepts.add((byte)0);
        return stateId;
    }

    @Override
    public int size() {
        return this.transitions.size();
    }

    public DFA copy() {
        DFA copy = new DFA();
        for (TIntIntHashMap t : this.transitions) {
            copy.transitions.add(new TIntIntHashMap((TIntIntMap)t));
        }
        copy.accepts = new TByteArrayList((TByteCollection)this.accepts);
        copy.initialState = this.initialState;
        return copy;
    }

    @Override
    public void addTransition(int sourceId, int symbol, int targetId) {
        this.transitions.get(sourceId).put(symbol, targetId);
    }

    public int getTransition(int sourceId, int symbol) {
        return this.transitions.get(sourceId).get(symbol);
    }

    @Override
    public void forEachTransition(int source, TIntIntProcedure proc) {
        this.transitions.get(source).forEachEntry(proc);
    }

    public int[] nextStates(int id) {
        return this.transitions.get(id).keys();
    }

    @Override
    public void setAccepts(int id, boolean accepts) {
        this.accepts.set(id, accepts ? (byte)1 : 0);
    }

    @Override
    public boolean getAccepts(int id) {
        return this.accepts.get(id) == 1;
    }

    @Override
    public void setInitialState(int initialState) {
        this.initialState = initialState;
    }

    @Override
    public int getInitialState() {
        return this.initialState;
    }

    public DFA minimize() {
        final TIntIntHashMap symbolMap = new TIntIntHashMap();
        final TIntArrayList l = new TIntArrayList();
        TIntProcedure proc = new TIntProcedure(){

            public boolean execute(int value) {
                if (!symbolMap.containsKey(value)) {
                    symbolMap.put(value, l.size());
                    l.add(value);
                }
                return true;
            }
        };
        for (TIntIntHashMap tMap : this.transitions) {
            tMap.forEachKey(proc);
        }
        int[] symbolArray = l.toArray();
        int symbolCount = symbolMap.size();
        int stateCount = this.transitions.size();
        TIntArrayList[][] inverse = new TIntArrayList[stateCount + 1][];
        int i = 0;
        while (i < inverse.length) {
            inverse[i] = new TIntArrayList[symbolCount];
            ++i;
        }
        int sourceId = 0;
        while (sourceId < stateCount) {
            TIntIntHashMap tMap = this.transitions.get(sourceId);
            int j = 0;
            while (j < symbolCount) {
                TIntArrayList l2;
                int targetId = tMap.get(symbolArray[j]);
                if (targetId == -1) {
                    targetId = stateCount;
                }
                if ((l2 = inverse[targetId][j]) == null) {
                    inverse[targetId][j] = l2 = new TIntArrayList();
                }
                l2.add(sourceId);
                ++j;
            }
            ++sourceId;
        }
        int[] ids = new int[stateCount + 1];
        final int[] memPartion = new int[stateCount + 1];
        TIntArrayList partionBegin = new TIntArrayList();
        TIntArrayList partionEnd = new TIntArrayList();
        TIntArrayList stack = new TIntArrayList();
        TIntArrayList scheduled = new TIntArrayList();
        int min = 0;
        int max = stateCount;
        ids[min++] = stateCount;
        memPartion[stateCount] = 0;
        int i2 = 0;
        while (i2 < stateCount) {
            if (this.accepts.get(i2) == 1) {
                ids[max--] = i2;
                memPartion[i2] = 1;
            } else {
                ids[min++] = i2;
                memPartion[i2] = 0;
            }
            ++i2;
        }
        partionBegin.add(0);
        partionBegin.add(min);
        partionEnd.add(min);
        partionEnd.add(ids.length);
        scheduled.add(0);
        scheduled.add(0);
        if (min < ids.length / 2) {
            stack.add(0);
            scheduled.set(0, 1);
        } else {
            stack.add(1);
            scheduled.set(1, 1);
        }
        while (!stack.isEmpty()) {
            int partionId = stack.removeAt(stack.size() - 1);
            scheduled.set(partionId, 0);
            int begin = partionBegin.get(partionId);
            int end = partionEnd.get(partionId);
            int j = 0;
            while (j < symbolCount) {
                int[] partionsArray;
                TIntHashSet invStates = new TIntHashSet();
                int i3 = begin;
                while (i3 < end) {
                    int s = ids[i3];
                    TIntArrayList inv = inverse[s][j];
                    if (inv != null) {
                        invStates.addAll((TIntCollection)inv);
                    }
                    ++i3;
                }
                int[] invStatesArray = invStates.toArray();
                TIntHashSet partions = new TIntHashSet();
                int[] nArray = invStatesArray;
                int n = invStatesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int s = nArray[n2];
                    partions.add(memPartion[s]);
                    ++n2;
                }
                int[] nArray2 = partionsArray = partions.toArray();
                int n3 = partionsArray.length;
                n = 0;
                while (n < n3) {
                    int p = nArray2[n];
                    int pBegin = partionBegin.get(p);
                    int pEnd = partionEnd.get(p);
                    boolean splits = false;
                    int k = pBegin;
                    while (k < pEnd) {
                        if (!invStates.contains(ids[k])) {
                            splits = true;
                            break;
                        }
                        ++k;
                    }
                    if (splits) {
                        int p2 = partionBegin.size();
                        int p2End = pEnd;
                        int k2 = pBegin;
                        while (k2 < pEnd) {
                            int s = ids[k2];
                            if (invStates.contains(s)) {
                                memPartion[s] = p2;
                                ids[k2] = ids[--pEnd];
                                ids[pEnd] = s;
                                --k2;
                            }
                            ++k2;
                        }
                        partionEnd.set(p, pEnd);
                        partionBegin.add(pEnd);
                        partionEnd.add(p2End);
                        if (scheduled.get(p) == 1) {
                            scheduled.add(1);
                            stack.add(p2);
                        } else if (pEnd - pBegin <= p2End - pEnd) {
                            stack.add(p);
                            scheduled.add(0);
                            scheduled.set(p, 1);
                        } else {
                            stack.add(p2);
                            scheduled.add(1);
                        }
                    }
                    ++n;
                }
                ++j;
            }
        }
        final DFA aut = new DFA();
        int failurePartion = memPartion[stateCount];
        final int[] sArray = new int[partionBegin.size()];
        sArray[failurePartion] = -1;
        int i4 = 0;
        while (i4 < partionBegin.size()) {
            if (i4 != failurePartion) {
                sArray[i4] = aut.newState();
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < partionBegin.size()) {
            if (i4 != failurePartion) {
                final int sourceId2 = sArray[i4];
                int bId = ids[partionBegin.get(i4)];
                this.forEachTransition(bId, new TIntIntProcedure(){

                    public boolean execute(int a, int b) {
                        aut.addTransition(sourceId2, a, sArray[memPartion[b]]);
                        return true;
                    }
                });
                aut.setAccepts(sourceId2, this.getAccepts(bId));
            }
            ++i4;
        }
        aut.setInitialState(sArray[memPartion[this.initialState]]);
        return aut;
    }

    public Regexp toRegexp(int from, byte[] to) {
        int stateCount = this.size();
        final int[] order = new int[stateCount];
        int i = 0;
        while (i < stateCount) {
            order[i] = i;
            ++i;
        }
        order[0] = from;
        order[from] = 0;
        Regexp[][] a = new Regexp[stateCount][stateCount];
        Regexp[] b = new Regexp[stateCount];
        int i2 = 0;
        while (i2 < stateCount) {
            b[i2] = to[order[i2]] == 1 ? Regexp.ONE : Regexp.ZERO;
            int j = 0;
            while (j < stateCount) {
                a[i2][j] = Regexp.ZERO;
                ++j;
            }
            final Regexp[] row = a[i2];
            this.forEachTransition(order[i2], new TIntIntProcedure(){

                public boolean execute(int symbol, int targetId) {
                    targetId = order[targetId];
                    row[targetId] = Regexp.or(row[targetId], new RAtom(symbol));
                    return true;
                }
            });
            ++i2;
        }
        int n = stateCount - 1;
        while (n >= 0) {
            Regexp ss = Regexp.star(a[n][n]);
            b[n] = Regexp.seq(ss, b[n]);
            int j = 0;
            while (j < stateCount) {
                a[n][j] = Regexp.seq(ss, a[n][j]);
                ++j;
            }
            int i3 = 0;
            while (i3 < n) {
                b[i3] = Regexp.or(b[i3], Regexp.seq(a[i3][n], b[n]));
                int j2 = 0;
                while (j2 < n) {
                    a[i3][j2] = Regexp.or(a[i3][j2], Regexp.seq(a[i3][n], a[n][j2]));
                    ++j2;
                }
                ++i3;
            }
            --n;
        }
        return b[0];
    }

    public Regexp toRegexp() {
        return this.toRegexp(this.initialState, this.accepts.toArray()).simplify();
    }

    public Regexp toRegexpTo(int position) {
        int stateCount = this.size();
        byte[] targetArray = new byte[stateCount];
        targetArray[position] = 1;
        return this.toRegexp(this.initialState, targetArray).simplify();
    }

    public Regexp toRegexpFrom(int position) {
        return this.toRegexp(position, this.accepts.toArray()).simplify();
    }

    public Regexp toPositionalRegexp(int position) {
        DFA aut = this.copy();
        int s = this.transitions.size();
        aut.transitions.add(aut.transitions.get(position));
        aut.transitions.set(position, new TIntIntHashMap());
        aut.addTransition(position, Integer.MIN_VALUE, s);
        aut.accepts.add(this.accepts.get(position));
        aut.accepts.set(position, (byte)0);
        return aut.toRegexp();
    }
}

