/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parser.grammar.input;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.simantics.scl.compiler.parser.grammar.input.Token;

public abstract class GrammarParser {
    public static final boolean TRACE = false;
    private static final int INITIAL_CAPACITY = 16;
    private static final int STATE_COUNT = 19;
    private static final int TERMINAL_COUNT = 16;
    private static final int NONTERMINAL_COUNT = 6;
    private static final int PRODUCT_COUNT = 8;
    private static final int[] ACTION_ROW_ID = new int[19];
    private static final int[] ACTION_COLUMN_ID = new int[16];
    private static final short[] ACTION_TABLE = new short[56];
    private static final int[] ERROR_TABLE = new int[10];
    private static final int[] GOTO_ROW_ID = new int[19];
    private static final int[] GOTO_COLUMN_ID = new int[6];
    private static final short[] GOTO_TABLE = new short[12];
    private static final int[] PRODUCT_LHS = new int[8];
    private static final short STATE_MASK = 4095;
    private static final short REDUCE_MASK = Short.MIN_VALUE;
    private static final short POP_MASK = 16384;
    private static final short PUSH_MASK = 8192;
    private static final short ERROR_ACTION = -1;
    private static final short ACCEPT_ACTION = -2;
    public static final String[] TERMINAL_NAMES = new String[]{"NONTERMINAL", "EQUALS", "BAR", "SEMICOLON", "INITIAL", "HASH", "TERMINAL", "COMMA", "SHIFT", "REDUCE", "STAR", "PLUS", "OPTIONAL", "LPAREN", "RPAREN", "EOF"};
    public static final String[] NONTERMINAL_NAMES = new String[]{"file", "declaration", "prod", "regexps", "regexp", "init$1"};
    private Object[] symbolStack = new Object[16];
    private int symbolStackLength = 0;
    private int[] stateStack = new int[16];
    private int[] symbolStackPositionStack = new int[16];
    private int stateStackLength = 0;
    private int reductionLength;

    static {
        try {
            DataInputStream input = new DataInputStream(GrammarParser.class.getResourceAsStream("GrammarParser.dat"));
            int i = 0;
            while (i < ACTION_ROW_ID.length) {
                GrammarParser.ACTION_ROW_ID[i] = input.readInt();
                ++i;
            }
            i = 0;
            while (i < ACTION_COLUMN_ID.length) {
                GrammarParser.ACTION_COLUMN_ID[i] = input.readInt();
                ++i;
            }
            i = 0;
            while (i < ACTION_TABLE.length) {
                GrammarParser.ACTION_TABLE[i] = input.readShort();
                ++i;
            }
            i = 0;
            while (i < ERROR_TABLE.length) {
                GrammarParser.ERROR_TABLE[i] = input.readInt();
                ++i;
            }
            i = 0;
            while (i < GOTO_ROW_ID.length) {
                GrammarParser.GOTO_ROW_ID[i] = input.readInt();
                ++i;
            }
            i = 0;
            while (i < GOTO_COLUMN_ID.length) {
                GrammarParser.GOTO_COLUMN_ID[i] = input.readInt();
                ++i;
            }
            i = 0;
            while (i < GOTO_TABLE.length) {
                GrammarParser.GOTO_TABLE[i] = input.readShort();
                ++i;
            }
            i = 0;
            while (i < PRODUCT_LHS.length) {
                GrammarParser.PRODUCT_LHS[i] = input.readInt();
                ++i;
            }
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static short getAction(int state, int symbol) {
        int id = 16 * state + symbol;
        if ((ERROR_TABLE[id >> 5] >> (id & 0x1F) & 1) != 0) {
            return -1;
        }
        return ACTION_TABLE[ACTION_ROW_ID[state] + ACTION_COLUMN_ID[symbol]];
    }

    private static short getGoto(int state, int symbol) {
        return GOTO_TABLE[GOTO_ROW_ID[state] + GOTO_COLUMN_ID[symbol]];
    }

    protected abstract Token nextToken();

    protected int length() {
        return this.reductionLength;
    }

    protected Object get(int i) {
        if (i < 0 || i >= this.reductionLength) {
            throw new IndexOutOfBoundsException();
        }
        return this.symbolStack[this.symbolStackLength + i];
    }

    private String parseErrorDescription(int state, Token token, int tokenId) {
        StringBuilder b = new StringBuilder();
        b.append("Unexpected token '").append(token).append("' (").append(TERMINAL_NAMES[tokenId]).append("). Expected one of ");
        ArrayList<String> possibleTerminals = new ArrayList<String>();
        int i = 0;
        while (i < 16) {
            if (GrammarParser.getAction(state, i) != -1) {
                possibleTerminals.add(TERMINAL_NAMES[i]);
            }
            ++i;
        }
        Collections.sort(possibleTerminals);
        i = 0;
        while (i < possibleTerminals.size()) {
            if (i > 0) {
                b.append(", ");
            }
            b.append((String)possibleTerminals.get(i));
            ++i;
        }
        b.append('.');
        return b.toString();
    }

    protected abstract RuntimeException syntaxError(Token var1, String var2);

    private static String describeAction(boolean isGoto, int action) {
        if (action == -1) {
            return "ERROR";
        }
        if (action == -2) {
            return "ACCEPT";
        }
        StringBuilder b = new StringBuilder();
        if (isGoto) {
            b.append("GOTO ");
        } else if ((action & Short.MIN_VALUE) != 0) {
            action ^= Short.MIN_VALUE;
            b.append("REDUCE");
        } else {
            b.append("SHIFT");
        }
        if ((action & 0x4000) != 0) {
            action ^= 0x4000;
            b.append(" POP");
        }
        if ((action & 0x2000) != 0) {
            action ^= 0x2000;
            b.append(" PUSH");
        }
        b.append(' ').append(action);
        return b.toString();
    }

    private void printState(int state) {
        System.out.print("state=" + state + ":");
        int i = this.symbolStackLength - 1;
        int j = this.stateStackLength - 1;
        while (i >= 0) {
            Object s = this.symbolStack[i];
            if (s instanceof Token) {
                System.out.print(" " + TERMINAL_NAMES[((Token)s).id]);
            } else if (s == null) {
                System.out.print(" null");
            } else {
                System.out.print(" " + s.getClass().getSimpleName());
            }
            while (j >= 0 && this.symbolStackPositionStack[j] == i) {
                System.out.print(" (" + this.stateStack[j--] + ")");
            }
            --i;
        }
        System.out.println();
    }

    private Object parse(int state) {
        while (true) {
            short action;
            Token token = this.nextToken();
            int tokenId = token.id;
            while (((action = GrammarParser.getAction(state, tokenId)) & Short.MIN_VALUE) != 0) {
                if (action == -2) {
                    return this.symbolStack[this.symbolStackLength - 1];
                }
                if (action == -1) {
                    throw this.syntaxError(token, this.parseErrorDescription(state, token, tokenId));
                }
                int popAmount = action >>> 13 & 3;
                this.stateStackLength -= popAmount;
                action = (short)(action & 0xFFF);
                int reductionBegin = this.symbolStackPositionStack[--this.stateStackLength];
                this.reductionLength = this.symbolStackLength - reductionBegin;
                this.symbolStackLength = reductionBegin;
                if (this.symbolStackLength == this.symbolStack.length) {
                    this.symbolStack = Arrays.copyOf(this.symbolStack, this.symbolStackLength * 2);
                }
                Object symbol = this.reduce(action);
                this.postReduce(symbol);
                this.symbolStack[this.symbolStackLength] = symbol;
                state = this.stateStack[this.stateStackLength];
                action = GrammarParser.getGoto(state, PRODUCT_LHS[action]);
                if ((action & 0x4000) != 0) {
                    --this.stateStackLength;
                }
                if ((action & 0x2000) != 0) {
                    if (this.stateStackLength == this.stateStack.length) {
                        this.stateStack = Arrays.copyOf(this.stateStack, this.stateStackLength * 2);
                        this.symbolStackPositionStack = Arrays.copyOf(this.symbolStackPositionStack, this.stateStackLength * 2);
                    }
                    this.symbolStackPositionStack[this.stateStackLength] = this.symbolStackLength;
                    this.stateStack[this.stateStackLength++] = state;
                }
                state = action & 0xFFF;
                ++this.symbolStackLength;
            }
            if ((action & 0x4000) != 0) {
                --this.stateStackLength;
            }
            if ((action & 0x2000) != 0) {
                if (this.stateStackLength == this.stateStack.length) {
                    this.stateStack = Arrays.copyOf(this.stateStack, this.stateStackLength * 2);
                    this.symbolStackPositionStack = Arrays.copyOf(this.symbolStackPositionStack, this.stateStackLength * 2);
                }
                this.symbolStackPositionStack[this.stateStackLength] = this.symbolStackLength;
                this.stateStack[this.stateStackLength++] = state;
            }
            state = action & 0xFFF;
            if (this.symbolStackLength == this.symbolStack.length) {
                this.symbolStack = Arrays.copyOf(this.symbolStack, this.symbolStackLength * 2);
            }
            this.symbolStack[this.symbolStackLength++] = token;
        }
    }

    public Object parseFile() {
        return this.parse(0);
    }

    /*
     * Unable to fully structure code
     */
    protected Object reduce(int productionId) {
        try {
            switch (productionId) {
                case 0: {
                    return this.reduceFile();
                }
                case 1: {
                    return this.reduceProduction();
                }
                case 2: {
                    return this.reduceInitial();
                }
                case 3: {
                    return this.reduceProductionRhs();
                }
                case 4: {
                    return this.reduceConcatenation();
                }
                case 5: {
                    return this.reduceTerminal();
                }
                case 6: {
                    return this.reduceUnion();
                }
            }
            throw new RuntimeException("Internal parser error.");
        }
        catch (RuntimeException e) {
            b = new StringBuilder();
            b.append("Failed to reduce");
            i = 0;
            ** while (i < this.length())
        }
lbl-1000:
        // 1 sources

        {
            obj = this.get(i);
            b.append("\n    (").append(i).append(") \"").append(obj).append('\"');
            if (obj instanceof Token) {
                b.append(" (").append(GrammarParser.TERMINAL_NAMES[((Token)obj).id]).append(")");
            } else {
                b.append(" [").append(obj.getClass().getSimpleName()).append("]");
            }
            ++i;
            continue;
        }
lbl35:
        // 1 sources

        throw new RuntimeException(b.toString(), e);
    }

    protected abstract Object reduceFile();

    protected abstract Object reduceProduction();

    protected abstract Object reduceInitial();

    protected abstract Object reduceProductionRhs();

    protected abstract Object reduceConcatenation();

    protected abstract Object reduceTerminal();

    protected abstract Object reduceUnion();

    protected void postReduce(Object reduced) {
    }
}

