/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parser.grammar;

import org.simantics.scl.compiler.parser.grammar.Production;
import org.simantics.scl.compiler.parser.regexp.Namer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Grammar
implements Namer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Grammar.class);
    public final Production[] productions;
    public final String[] terminalNames;
    public final String[] nonterminalNames;
    public final int[] initialNonterminals;

    public Grammar(Production[] productions, String[] terminalNames, String[] nonterminalNames, int[] initialNonterminals) {
        this.productions = productions;
        this.terminalNames = terminalNames;
        this.nonterminalNames = nonterminalNames;
        this.initialNonterminals = initialNonterminals;
    }

    @Override
    public String getName(int symbolId) {
        if (symbolId >= 0) {
            return this.terminalNames[symbolId];
        }
        return this.nonterminalNames[~symbolId];
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        Production[] productionArray = this.productions;
        int n = this.productions.length;
        int n2 = 0;
        while (n2 < n) {
            Production prod = productionArray[n2];
            b.append(prod.toString(this));
            b.append("\n");
            ++n2;
        }
        return b.toString();
    }

    public void check() {
        int[] prodCount = new int[this.nonterminalNames.length];
        Production[] productionArray = this.productions;
        int n = this.productions.length;
        int n2 = 0;
        while (n2 < n) {
            Production prod = productionArray[n2];
            int n3 = ~prod.lhs;
            prodCount[n3] = prodCount[n3] + 1;
            ++n2;
        }
        int i = 0;
        while (i < this.nonterminalNames.length) {
            if (prodCount[i] == 0) {
                LOGGER.error("Nonterminal " + this.nonterminalNames[i] + " does not have productions.");
            }
            ++i;
        }
    }
}

