/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parser.generator.table;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.simantics.scl.compiler.parser.generator.compression.CompressedParseTable;
import org.simantics.scl.compiler.parser.generator.compression.ErrorTable;
import org.simantics.scl.compiler.parser.generator.compression.GCCompress;

public class ParseTable {
    public final int stateCount;
    public final int[][] actionTable;
    public final int[][] gotoTable;
    public final int[] productionInfo;
    public final int[] initialStates;
    public final String[] stateDescriptions;

    public ParseTable(int stateCount, int[][] actionTable, int[][] gotoTable, int[] productionInfo, int[] initialStates, String[] stateDescriptions) {
        this.stateCount = stateCount;
        this.actionTable = actionTable;
        this.gotoTable = gotoTable;
        this.productionInfo = productionInfo;
        this.initialStates = initialStates;
        this.stateDescriptions = stateDescriptions;
    }

    public String toString() {
        int i;
        StringBuilder b = new StringBuilder();
        b.append("productionInfo = ").append(Arrays.toString(this.productionInfo)).append('\n');
        b.append("actions:\n");
        int[][] nArray = this.actionTable;
        int n = this.actionTable.length;
        int n2 = 0;
        while (n2 < n) {
            int[] actions = nArray[n2];
            b.append("    {");
            i = 0;
            while (i < actions.length) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(actions[i]);
                ++i;
            }
            b.append("},\n");
            ++n2;
        }
        b.append("gotos:\n");
        nArray = this.gotoTable;
        n = this.gotoTable.length;
        n2 = 0;
        while (n2 < n) {
            int[] gotos = nArray[n2];
            b.append("    {");
            i = 0;
            while (i < gotos.length) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(gotos[i]);
                ++i;
            }
            b.append("},\n");
            ++n2;
        }
        return b.toString();
    }

    public CompressedParseTable compress() {
        return new CompressedParseTable(GCCompress.compress(this.actionTable), ErrorTable.createErrorTable(this.actionTable), GCCompress.compress(this.gotoTable), this.productionInfo, this.initialStates, this.stateDescriptions);
    }

    public void writeTo(File file) throws IOException {
        int val;
        int n;
        int n2;
        int[] nArray;
        int[] row;
        FileOutputStream stream = new FileOutputStream(file);
        DataOutputStream output = new DataOutputStream(stream);
        Object object = this.actionTable;
        int n3 = this.actionTable.length;
        int n4 = 0;
        while (n4 < n3) {
            nArray = row = object[n4];
            n2 = row.length;
            n = 0;
            while (n < n2) {
                val = nArray[n];
                output.writeInt(val);
                ++n;
            }
            ++n4;
        }
        object = this.gotoTable;
        n3 = this.gotoTable.length;
        n4 = 0;
        while (n4 < n3) {
            nArray = row = object[n4];
            n2 = row.length;
            n = 0;
            while (n < n2) {
                val = nArray[n];
                output.writeInt(val);
                ++n;
            }
            ++n4;
        }
        object = this.productionInfo;
        n3 = this.productionInfo.length;
        n4 = 0;
        while (n4 < n3) {
            int[] val2 = object[n4];
            output.writeInt((int)val2);
            ++n4;
        }
        output.close();
    }
}

