/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parser.generator.grammar;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntByteHashMap;
import gnu.trove.procedure.TIntIntProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.scl.compiler.parser.generator.grammar.Prod;
import org.simantics.scl.compiler.parser.grammar.Grammar;
import org.simantics.scl.compiler.parser.grammar.Production;
import org.simantics.scl.compiler.parser.regexp.Namer;
import org.simantics.scl.compiler.parser.regexp.automata.DFA;

public class AnaGrammar
implements Namer {
    public ArrayList<Prod> prods = new ArrayList();
    public int[] nonterminalPos;
    public final String[] terminalNames;
    public final String[] nonterminalNames;
    public final int[] initialNonterminals;
    public boolean[] nullable;
    public int[][] first;

    public AnaGrammar(Grammar grammar) {
        this.initialNonterminals = grammar.initialNonterminals;
        this.terminalNames = Arrays.copyOf(grammar.terminalNames, grammar.terminalNames.length + 1);
        this.terminalNames[this.terminalNames.length - 1] = "EOF";
        this.nonterminalNames = Arrays.copyOf(grammar.nonterminalNames, grammar.nonterminalNames.length + this.initialNonterminals.length);
        int i = 1;
        while (i <= this.initialNonterminals.length) {
            this.nonterminalNames[this.nonterminalNames.length - i] = "init$" + i;
            ++i;
        }
        ArrayList[] prodMap = new ArrayList[this.nonterminalNames.length];
        int i2 = 0;
        while (i2 < this.nonterminalNames.length) {
            prodMap[i2] = new ArrayList();
            ++i2;
        }
        Production[] productionArray = grammar.productions;
        int n = grammar.productions.length;
        int n2 = 0;
        while (n2 < n) {
            Production production = productionArray[n2];
            Prod prod = new Prod(production.name, ~production.lhs, production.rhs.toAutomaton().determinize().minimize(), production.annotations);
            prodMap[prod.lhs].add(prod);
            ++n2;
        }
        i = 1;
        while (i <= this.initialNonterminals.length) {
            DFA dfa = new DFA();
            int s0 = dfa.newState();
            dfa.setInitialState(s0);
            int s1 = dfa.newState();
            dfa.addTransition(s0, this.initialNonterminals[i - 1], s1);
            int s2 = dfa.newState();
            dfa.addTransition(s1, this.terminalNames.length - 1, s2);
            dfa.setAccepts(s2, true);
            Prod prod = new Prod("Init", this.nonterminalNames.length - i, dfa, new TIntByteHashMap());
            prodMap[prod.lhs].add(prod);
            ++i;
        }
        TIntArrayList pos = new TIntArrayList();
        int i3 = 0;
        while (i3 < this.nonterminalNames.length) {
            pos.add(this.prods.size());
            this.prods.addAll(prodMap[i3]);
            ++i3;
        }
        pos.add(this.prods.size());
        this.nonterminalPos = pos.toArray();
        this.computeNullableNonterminals();
    }

    private void computeNullableNonterminals() {
        int nonterminalCount = this.nonterminalNames.length;
        this.nullable = new boolean[nonterminalCount];
        final TIntHashSet[] first = new TIntHashSet[nonterminalCount];
        final TIntHashSet[] gfirst = new TIntHashSet[nonterminalCount];
        int i = 0;
        while (i < nonterminalCount) {
            first[i] = new TIntHashSet();
            gfirst[i] = new TIntHashSet();
            ++i;
        }
        final ArrayList[] pendingItems = new ArrayList[nonterminalCount];
        final ArrayList<FrontierItem> stack = new ArrayList<FrontierItem>();
        THashSet handledItems = new THashSet();
        int i2 = 0;
        while (i2 < nonterminalCount) {
            pendingItems[i2] = new ArrayList();
            ++i2;
        }
        i2 = 0;
        while (i2 < this.prods.size()) {
            stack.add(new FrontierItem(i2, this.prods.get((int)i2).rhs.getInitialState()));
            ++i2;
        }
        while (!stack.isEmpty()) {
            final FrontierItem cur = (FrontierItem)stack.remove(stack.size() - 1);
            if (!handledItems.add((Object)cur)) continue;
            final Prod curProd = this.prods.get(cur.production);
            if (curProd.rhs.getAccepts(cur.state)) {
                this.nullable[curProd.lhs] = true;
                stack.addAll(pendingItems[curProd.lhs]);
            }
            curProd.rhs.forEachTransition(cur.state, new TIntIntProcedure(){

                public boolean execute(int symbol, int targetState) {
                    if (symbol < 0) {
                        gfirst[symbol ^= 0xFFFFFFFF].add(curProd.lhs);
                        FrontierItem item = new FrontierItem(cur.production, targetState);
                        if (AnaGrammar.this.nullable[symbol]) {
                            stack.add(item);
                        } else {
                            pendingItems[symbol].add(item);
                        }
                    } else {
                        first[curProd.lhs].add(symbol);
                    }
                    return true;
                }
            });
        }
        AnaGrammar.gclose(first, gfirst);
        this.first = new int[first.length][];
        i = 0;
        while (i < first.length) {
            this.first[i] = first[i].toArray();
            ++i;
        }
    }

    public static void gclose(TIntHashSet[] sets, TIntHashSet[] graph_) {
        int[][] graph = new int[graph_.length][];
        int i = 0;
        while (i < graph.length) {
            graph[i] = graph_[i].toArray();
            ++i;
        }
        final TIntArrayList stack = new TIntArrayList();
        int i2 = 0;
        while (i2 < sets.length) {
            final int i_ = i2;
            sets[i2].forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    stack.add(i_);
                    stack.add(value);
                    return true;
                }
            });
            ++i2;
        }
        while (!stack.isEmpty()) {
            int sp = stack.size();
            int value = stack.removeAt(sp - 1);
            int id = stack.removeAt(sp - 2);
            int[] nArray = graph[id];
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int s = nArray[n2];
                if (sets[s].add(value)) {
                    stack.add(s);
                    stack.add(value);
                }
                ++n2;
            }
        }
    }

    @Override
    public String getName(int symbolId) {
        if (symbolId >= 0) {
            return this.terminalNames[symbolId];
        }
        return this.nonterminalNames[~symbolId];
    }

    public boolean almostAccepts(DFA rhs, int position) {
        AlmostAcceptsProc proc = new AlmostAcceptsProc(rhs);
        proc.visit(position);
        return proc.result;
    }

    private class AlmostAcceptsProc
    implements TIntIntProcedure {
        DFA rhs;
        TIntHashSet visited = new TIntHashSet();
        boolean result;

        public AlmostAcceptsProc(DFA rhs) {
            this.rhs = rhs;
        }

        public boolean execute(int a, int b) {
            if (a < 0 && AnaGrammar.this.nullable[~a]) {
                this.visit(b);
            }
            return !this.result;
        }

        public void visit(int position) {
            if (this.visited.add(position)) {
                if (this.rhs.getAccepts(position)) {
                    this.result = true;
                    return;
                }
                this.rhs.forEachTransition(position, this);
            }
        }
    }

    private static class FrontierItem {
        public final int production;
        public final int state;

        public FrontierItem(int production, int state) {
            this.production = production;
            this.state = state;
        }

        public int hashCode() {
            return 31 * this.state + this.production;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            FrontierItem other = (FrontierItem)obj;
            return other.state == this.state && other.production == this.production;
        }
    }
}

