/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.module.repository;

import gnu.trove.procedure.TObjectProcedure;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.environment.filter.AcceptAllNamespaceFilter;
import org.simantics.scl.compiler.environment.filter.NamespaceFilter;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.repository.ModuleRepository;

public class ModuleRepositories {
    public static List<SCLValue> allValuesMatching(final ModuleRepository repository, String pattern) {
        final Pattern compiledPattern = pattern == null ? null : Pattern.compile(".*" + pattern + ".*", 2);
        final ArrayList<SCLValue> results = new ArrayList<SCLValue>();
        repository.getSourceRepository().forAllModules(new TObjectProcedure<String>(){

            public boolean execute(String moduleName) {
                Failable<Module> failableModule = repository.getModule(moduleName);
                if (!failableModule.didSucceed()) {
                    return true;
                }
                Module module = failableModule.getResult();
                module.findValuesForPrefix("", (NamespaceFilter)AcceptAllNamespaceFilter.INSTANCE, new TObjectProcedure<SCLValue>(){

                    public boolean execute(SCLValue value) {
                        String name = value.getName().name;
                        if (!(value.isPrivate() || name.startsWith("_") || name.contains("$") && Character.isLetter(name.charAt(0)) || compiledPattern != null && !compiledPattern.matcher(name).matches())) {
                            results.add(value);
                        }
                        return true;
                    }
                });
                return true;
            }
        });
        return results;
    }

    public static List<SCLValue> allValues(ModuleRepository repository) {
        return ModuleRepositories.allValuesMatching(repository, null);
    }
}

