/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.module.options;

import java.util.Objects;
import org.simantics.scl.compiler.module.options.DefaultStoredModuleSupport;
import org.simantics.scl.compiler.module.options.StoredModuleSupport;

public class ModuleCompilationOptions {
    public static final ModuleCompilationOptions STANDARD_OPTIONS = new ModuleCompilationOptions(false);
    public static final ModuleCompilationOptions SILENT = new ModuleCompilationOptions(false);
    private static final StoredModuleSupport DEFAULT_CLASS_LOADER_PROVIDER = new DefaultStoredModuleSupport();
    public boolean computeCoverage;
    public StoreOption store;
    public boolean silent = false;
    public boolean collectDebugInfo = false;
    public StoredModuleSupport classLoaderProvider;

    static {
        ModuleCompilationOptions.SILENT.silent = true;
    }

    public ModuleCompilationOptions(boolean computeCoverage) {
        this(computeCoverage, StoreOption.NONE);
    }

    public ModuleCompilationOptions(boolean computeCoverage, StoreOption store) {
        this(computeCoverage, store, false, false, DEFAULT_CLASS_LOADER_PROVIDER);
    }

    private ModuleCompilationOptions(boolean computeCoverage, StoreOption store, boolean silent, boolean collectDebugInfo, StoredModuleSupport classLoaderProvider) {
        this.computeCoverage = computeCoverage;
        this.store = store;
        this.silent = silent;
        this.collectDebugInfo = collectDebugInfo;
        this.classLoaderProvider = classLoaderProvider;
    }

    public ModuleCompilationOptions withStore(StoreOption value) {
        if (Objects.equals((Object)this.store, (Object)value)) {
            return this;
        }
        return new ModuleCompilationOptions(this.computeCoverage, value, this.silent, this.collectDebugInfo, this.classLoaderProvider);
    }

    public static enum StoreOption {
        NONE,
        READ,
        WRITE;


        public static StoreOption parse(String value) {
            if ("write".equals(value)) {
                return WRITE;
            }
            if ("read".equals(value)) {
                return READ;
            }
            return NONE;
        }
    }
}

