/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.module.coverage;

import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Map;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.coverage.CombinedCoverage;
import org.simantics.scl.compiler.module.coverage.FunctionCoverage;
import org.simantics.scl.compiler.module.coverage.ModuleCoverage;
import org.simantics.scl.runtime.profiling.BranchPoint;

public class CoverageUtils {
    public static ModuleCoverage getCoverage(String moduleName, THashMap<String, BranchPoint[]> branchPoints) {
        THashMap methodCoverages = new THashMap();
        int totalCodeSize = 0;
        int coveredCodeSize = 0;
        int totalFunctionCount = 0;
        int coveredFunctionCount = 0;
        for (Map.Entry entry : branchPoints.entrySet()) {
            int totalFunctionCodeSize = 0;
            int uncoveredFunctionCodeSize = 0;
            BranchPoint[] branchPointArray = (BranchPoint[])entry.getValue();
            int n = branchPointArray.length;
            int n2 = 0;
            while (n2 < n) {
                BranchPoint branchPoint = branchPointArray[n2];
                totalFunctionCodeSize += branchPoint.getCodeSize();
                uncoveredFunctionCodeSize += CoverageUtils.uncoveredCodeSize(branchPoint);
                ++n2;
            }
            int coveredFunctionCodeSize = totalFunctionCodeSize - uncoveredFunctionCodeSize;
            String functionName = (String)entry.getKey();
            methodCoverages.put((Object)functionName, (Object)new FunctionCoverage(functionName, totalFunctionCodeSize, coveredFunctionCodeSize));
            totalCodeSize += totalFunctionCodeSize;
            coveredCodeSize += coveredFunctionCodeSize;
            ++totalFunctionCount;
            if (coveredFunctionCodeSize <= 0) continue;
            ++coveredFunctionCount;
        }
        return new ModuleCoverage(moduleName, (THashMap<String, FunctionCoverage>)methodCoverages, totalCodeSize, coveredCodeSize, totalFunctionCount, coveredFunctionCount);
    }

    public static ModuleCoverage getCoverage(Module module) {
        THashMap<String, BranchPoint[]> branchPoints = module.getBranchPoints();
        if (branchPoints == null) {
            return null;
        }
        return CoverageUtils.getCoverage(module.getName(), branchPoints);
    }

    public static CombinedCoverage combineCoverages(THashMap<String, ModuleCoverage> moduleCoverages) {
        int totalCodeSize = 0;
        int coveredCodeSize = 0;
        int totalFunctionCount = 0;
        int coveredFunctionCount = 0;
        for (ModuleCoverage mCov : moduleCoverages.values()) {
            totalCodeSize += mCov.getTotalCodeSize();
            coveredCodeSize += mCov.getCoveredCodeSize();
            totalFunctionCount += mCov.totalFunctionCount;
            coveredFunctionCount += mCov.coveredFunctionCount;
        }
        return new CombinedCoverage(moduleCoverages, totalCodeSize, coveredCodeSize, totalFunctionCount, coveredFunctionCount);
    }

    public static CombinedCoverage getCoverage(Collection<Module> modules) {
        THashMap moduleCoverages = new THashMap();
        for (Module module : modules) {
            ModuleCoverage coverage = CoverageUtils.getCoverage(module);
            if (coverage == null) continue;
            moduleCoverages.put((Object)module.getName(), (Object)coverage);
        }
        return CoverageUtils.combineCoverages((THashMap<String, ModuleCoverage>)moduleCoverages);
    }

    public static void resetCoverage(Collection<Module> modules) {
        modules.forEach(CoverageUtils::resetCoverage);
    }

    public static void resetCoverage(Module module) {
        THashMap<String, BranchPoint[]> branches = module.getBranchPoints();
        if (branches != null) {
            for (BranchPoint[] points : branches.values()) {
                if (points == null) continue;
                BranchPoint[] branchPointArray = points;
                int n = points.length;
                int n2 = 0;
                while (n2 < n) {
                    BranchPoint point = branchPointArray[n2];
                    point.resetVisitCountersRecursively();
                    ++n2;
                }
            }
        }
    }

    static double safeDiv(int a, int b) {
        if (b == 0) {
            return 1.0;
        }
        return (double)a / (double)b;
    }

    private static int uncoveredCodeSize(BranchPoint branchPoint) {
        if (branchPoint.getVisitCounter() == 0) {
            return branchPoint.getCodeSize();
        }
        int sum = 0;
        BranchPoint[] branchPointArray = branchPoint.getChildren();
        int n = branchPointArray.length;
        int n2 = 0;
        while (n2 < n) {
            BranchPoint child = branchPointArray[n2];
            sum += CoverageUtils.uncoveredCodeSize(child);
            ++n2;
        }
        return sum;
    }
}

