/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.module.coverage;

import gnu.trove.map.hash.THashMap;
import java.io.PrintStream;
import java.util.Arrays;
import org.simantics.scl.compiler.module.coverage.AbstractCoverage;
import org.simantics.scl.compiler.module.coverage.CoverageUtils;
import org.simantics.scl.compiler.module.coverage.ModuleCoverage;

public class CombinedCoverage
extends AbstractCoverage {
    public final THashMap<String, ModuleCoverage> moduleCoverages;
    public final int totalFunctionCount;
    public final int coveredFunctionCount;
    public final double functionCoverage;

    public CombinedCoverage(THashMap<String, ModuleCoverage> moduleCoverages, int totalCodeSize, int coveredCodeSize, int totalFunctionCount, int coveredFunctionCount) {
        super("Total coverage of " + moduleCoverages.size() + " modules", totalCodeSize, coveredCodeSize);
        this.moduleCoverages = moduleCoverages;
        this.totalFunctionCount = totalFunctionCount;
        this.coveredFunctionCount = coveredFunctionCount;
        this.functionCoverage = CoverageUtils.safeDiv(coveredFunctionCount, totalFunctionCount);
    }

    public void print(PrintStream s) {
        s.println("Code coverage: " + this.toPercent(this.getCoverage()) + " (" + this.getCoveredCodeSize() + " / " + this.getTotalCodeSize() + ")");
        s.println("Function coverage: " + this.toPercent(this.functionCoverage) + " (" + this.coveredFunctionCount + " / " + this.totalFunctionCount + ")");
        Object[] moduleNames = this.moduleCoverages.keySet().toArray(new String[this.moduleCoverages.size()]);
        Arrays.sort(moduleNames);
        Object[] objectArray = moduleNames;
        int n = moduleNames.length;
        int n2 = 0;
        while (n2 < n) {
            Object functionName = objectArray[n2];
            ModuleCoverage mCov = (ModuleCoverage)this.moduleCoverages.get(functionName);
            s.println("    " + (String)functionName + ": " + this.toPercent(mCov.getCoverage()) + " (" + mCov.getCoveredCodeSize() + " / " + mCov.getTotalCodeSize() + ")");
            ++n2;
        }
    }
}

