/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.markdown.nodes;

import org.simantics.scl.compiler.markdown.inlines.Entities;
import org.simantics.scl.compiler.markdown.inlines.Subject;

public class Reference {
    public final String label;
    public final String url;
    public final String title;

    public Reference(String label, String url, String title) {
        this.label = label;
        this.url = url;
        this.title = title;
    }

    public static String normalizeLabel(String label) {
        StringBuilder b = new StringBuilder();
        int pos = 0;
        while (pos < label.length() && Character.isWhitespace(label.charAt(pos))) {
            ++pos;
        }
        boolean ws = false;
        while (pos < label.length()) {
            char c;
            if (Character.isWhitespace(c = label.charAt(pos++))) {
                ws = true;
                continue;
            }
            if (ws) {
                b.append(' ');
            }
            b.append(Character.toLowerCase(c));
        }
        return b.toString();
    }

    public static String cleanUrl(String input) {
        StringBuilder b = new StringBuilder();
        int pos = 0;
        block0: while (pos < input.length()) {
            char c;
            if ((c = input.charAt(pos++)) == '\\' && pos < input.length()) {
                c = input.charAt(pos);
                if (Subject.getCharType(c) == 2) {
                    b.append(c);
                    ++pos;
                    continue;
                }
                b.append('\\');
                continue;
            }
            if (c == '&') {
                int maxPos = Math.min(input.length(), pos + Entities.MAX_ENTITY_LENGTH + 1);
                int p = pos;
                do {
                    if (p != maxPos) continue;
                    b.append("&");
                    continue block0;
                } while ((c = input.charAt(p++)) != ';');
                String entity = input.substring(pos, p - 1);
                String character = (String)Entities.ENTITY_MAP.get((Object)entity);
                if (character == null) {
                    b.append("&");
                    continue;
                }
                pos = p;
                b.append(character);
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String cleanTitle(String input) {
        return Reference.cleanUrl(input);
    }
}

