/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.types;

import gnu.trove.map.hash.THashMap;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.ITypeEnvironment;

public class TypeElaborationContext {
    THashMap<String, TVar> vars;
    THashMap<String, TMetaVar> existentials;
    ITypeEnvironment environment;

    public TypeElaborationContext(THashMap<String, TVar> vars, ITypeEnvironment environment) {
        this.vars = vars;
        this.environment = environment;
    }

    public TypeElaborationContext(ITypeEnvironment environment) {
        this((THashMap<String, TVar>)new THashMap(), environment);
    }

    public TMetaVar resolveExistential(String varName) {
        TMetaVar var;
        if (this.existentials == null) {
            this.existentials = new THashMap();
        }
        if ((var = (TMetaVar)this.existentials.get((Object)varName)) == null) {
            var = Types.metaVar(Kinds.metaVar());
            this.existentials.put((Object)varName, (Object)var);
        }
        return var;
    }

    public TVar resolveTypeVariable(String varName) {
        TVar var = (TVar)this.vars.get((Object)varName);
        if (var == null) {
            var = Types.var(Kinds.metaVar());
            this.vars.put((Object)varName, (Object)var);
        }
        return var;
    }

    public TVar push(String varName) {
        return (TVar)this.vars.put((Object)varName, (Object)Types.var(Kinds.metaVar()));
    }

    public TVar pop(String varName, TVar oldVar) {
        if (oldVar == null) {
            return (TVar)this.vars.remove((Object)varName);
        }
        return (TVar)this.vars.put((Object)varName, (Object)oldVar);
    }

    public Type resolveTypeConstructor(String name) {
        return this.environment.resolve(null, name);
    }

    public Type resolveTypeConstructor(String namespace, String name) {
        return this.environment.resolve(namespace, name);
    }
}

