/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.parsing.utils;

import java.io.IOException;
import java.io.Reader;
import org.simantics.scl.compiler.errors.Locations;

public class MemoReader
extends Reader {
    Reader base;
    char[] buffer = new char[80];
    int absoluteBegin = 0;
    int begin = 0;
    int end = 0;
    int firstLine = 1;
    int[] lineLocations = new int[8];
    int lineLocationsPos;

    public MemoReader(Reader base) {
        this.base = base;
        this.addLine(0);
    }

    private int findLineLocationArrayOffset(int location) {
        int l = 0;
        int h = this.lineLocationsPos;
        while (l + 1 < h) {
            int c = l + h >> 1;
            int loc = this.lineLocations[c];
            if (loc <= location) {
                l = c;
                continue;
            }
            h = c;
        }
        return l;
    }

    private void addLine(int location) {
        if (this.lineLocationsPos == this.lineLocations.length) {
            int p = this.findLineLocationArrayOffset(this.absoluteBegin);
            if (p * 2 >= this.lineLocationsPos) {
                System.arraycopy(this.lineLocations, p, this.lineLocations, 0, this.lineLocationsPos - p);
            } else {
                int[] newLineLocations = new int[this.lineLocations.length * 2];
                System.arraycopy(this.lineLocations, p, newLineLocations, 0, this.lineLocationsPos - p);
                this.lineLocations = newLineLocations;
            }
            this.lineLocationsPos -= p;
            this.firstLine += p;
        }
        this.lineLocations[this.lineLocationsPos++] = location;
    }

    public String locationToString(int location) {
        int lOffset = this.findLineLocationArrayOffset(location);
        int row = lOffset + this.firstLine;
        int column = location + 1 - this.lineLocations[lOffset];
        return row + ":" + column;
    }

    public String locationToString(long location) {
        if (location == 9223372034707292160L) {
            return "";
        }
        return this.locationToString(Locations.beginOf(location)) + "-" + this.locationToString(Locations.endOf(location)) + ": ";
    }

    public String locationUnderlining(long coupledLocation) {
        int location = Locations.beginOf(coupledLocation);
        int lOffset = this.findLineLocationArrayOffset(location);
        int beginRow = lOffset + this.firstLine;
        int beginColumn = location - this.lineLocations[lOffset] + 2;
        location = Locations.endOf(coupledLocation);
        lOffset = this.findLineLocationArrayOffset(location);
        int endRow = lOffset + this.firstLine;
        int endColumn = location - this.lineLocations[lOffset] + 2;
        StringBuilder b = new StringBuilder();
        while (b.length() < beginColumn) {
            b.append(' ');
        }
        if (beginRow == endRow) {
            int end = Math.max(endColumn, beginColumn + 1);
            while (b.length() < end) {
                b.append('^');
            }
        } else {
            b.append("^^^...");
        }
        b.append(" (").append(beginRow).append(':').append(beginColumn).append('-').append(endRow).append(':').append(endColumn).append(')');
        return b.toString();
    }

    private void ensureCapacity(int count) {
        if (this.end + count > this.buffer.length) {
            if (this.end - this.begin + count <= this.buffer.length) {
                System.arraycopy(this.buffer, this.begin, this.buffer, 0, this.end - this.begin);
                this.end -= this.begin;
                this.begin = 0;
            } else {
                char[] newBuffer = new char[Math.max(this.buffer.length * 2, this.end + count)];
                System.arraycopy(this.buffer, this.begin, newBuffer, this.begin, this.end - this.begin);
                this.buffer = newBuffer;
            }
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int count = this.base.read(cbuf, off, len);
        if (count > 0) {
            int i = 0;
            while (i < count) {
                if (cbuf[off + i] == '\n') {
                    this.addLine(this.end + i + 1);
                }
                ++i;
            }
            this.ensureCapacity(count);
            System.arraycopy(cbuf, off, this.buffer, this.end, count);
            this.end += count;
        }
        return count;
    }

    @Override
    public int read() throws IOException {
        int result = this.base.read();
        if (result >= 0) {
            this.ensureCapacity(1);
            this.buffer[this.end++] = (char)result;
            if (result == 10) {
                this.addLine(this.end);
            }
        }
        return result;
    }

    public String extractString(long location) {
        int requestedBegin = Locations.beginOf(location);
        int requestedEnd = Locations.endOf(location);
        if (requestedBegin < this.absoluteBegin) {
            throw new IllegalArgumentException();
        }
        return new String(this.buffer, this.begin + requestedBegin - this.absoluteBegin, requestedEnd - requestedBegin);
    }

    public void forgetEverythingBefore(int location) {
        this.begin += location - this.absoluteBegin;
        this.absoluteBegin = location;
    }

    @Override
    public void close() throws IOException {
        this.base.close();
    }

    public String getLastCommand() {
        int p;
        try {
            int c;
            while ((c = this.read()) >= 0 && c != 10) {
            }
        }
        catch (IOException iOException) {}
        if (this.buffer[p = this.begin] == '\n') {
            ++p;
        }
        return new String(this.buffer, p, this.end - p);
    }
}

