/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.parsing.types;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.List;
import org.simantics.scl.compiler.elaboration.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;
import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class TTupleAst
extends TypeAst {
    public final TypeAst[] components;

    public TTupleAst(TypeAst ... components) {
        this.components = components;
    }

    public TTupleAst(List<TypeAst> components) {
        this(components.toArray(new TypeAst[components.size()]));
    }

    @Override
    public void toString(StringBuilder b) {
        b.append('(');
        int i = 0;
        while (i < this.components.length) {
            if (i > 0) {
                b.append(", ");
            }
            this.components[i].toString(b);
            ++i;
        }
        b.append(')');
    }

    @Override
    public Type toType(TypeTranslationContext context, Kind expectedKind) {
        if (this.components.length == 1) {
            return this.components[0].toType(context, expectedKind);
        }
        context.unify(this.location, Kinds.STAR, expectedKind);
        return Types.tuple(TTupleAst.toTypes(context, this.components));
    }

    @Override
    public Type toType(TypeElaborationContext context) {
        if (this.components.length == 1) {
            return this.components[0].toType(context);
        }
        return Types.tuple(TTupleAst.toTypes(context, this.components));
    }

    @Override
    public int getPrecedence() {
        return 0;
    }

    @Override
    public void collectReferences(TObjectIntHashMap<String> typeNameMap, TIntHashSet set) {
        TypeAst[] typeAstArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            TypeAst component = typeAstArray[n2];
            component.collectReferences(typeNameMap, set);
            ++n2;
        }
    }
}

