/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.parsing.types;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.elaboration.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.internal.parsing.types.TFunctionAst;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;
import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.kinds.Kind;

public class TPlainEffectAst
extends TypeAst {
    public final TypeAst[] effects;

    public TPlainEffectAst(TypeAst[] effects) {
        this.effects = effects;
    }

    public TPlainEffectAst(ArrayList<TypeAst> effects) {
        this(effects.toArray(new TypeAst[effects.size()]));
    }

    @Override
    public void toString(StringBuilder b) {
        b.append("<<");
        boolean first = true;
        TypeAst[] typeAstArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            TypeAst effect = typeAstArray[n2];
            if (first) {
                first = false;
            } else {
                b.append(",");
            }
            effect.toString(b);
            ++n2;
        }
        b.append(">>");
    }

    @Override
    public Type toType(TypeTranslationContext context, Kind expectedKind) {
        return TFunctionAst.toEffect(context, this.effects);
    }

    @Override
    public Type toType(TypeElaborationContext context) {
        return TFunctionAst.toEffect(context, this.effects);
    }

    @Override
    public int getPrecedence() {
        return 0;
    }

    @Override
    public void collectReferences(TObjectIntHashMap<String> typeNameMap, TIntHashSet set) {
        TypeAst[] typeAstArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            TypeAst effect = typeAstArray[n2];
            effect.collectReferences(typeNameMap, set);
            ++n2;
        }
    }
}

