/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.parsing.types;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.elaboration.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.internal.parsing.types.TEffectAst;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;
import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class TFunctionAst
extends TypeAst {
    public final TypeAst domain;
    public final TypeAst range;

    public TFunctionAst(TypeAst domain, TypeAst range) {
        this.domain = domain;
        this.range = range;
    }

    @Override
    public void toString(StringBuilder b) {
        this.domain.toString(b, 2);
        b.append(" -> ");
        this.range.toString(b, 3);
    }

    @Override
    public Type toType(TypeTranslationContext context, Kind expectedKind) {
        context.unify(this.location, Kinds.STAR, expectedKind);
        if (this.range instanceof TEffectAst) {
            TEffectAst effectAst = (TEffectAst)this.range;
            return Types.functionE(this.domain.toType(context, Kinds.STAR), TFunctionAst.toEffect(context, effectAst.effects), effectAst.type.toType(context, Kinds.STAR));
        }
        return Types.function(this.domain.toType(context, Kinds.STAR), this.range.toType(context, Kinds.STAR));
    }

    @Override
    public Type toType(TypeElaborationContext context) {
        if (this.range instanceof TEffectAst) {
            TEffectAst effectAst = (TEffectAst)this.range;
            return Types.functionE(this.domain.toType(context), TFunctionAst.toEffect(context, effectAst.effects), effectAst.type.toType(context));
        }
        return Types.function(this.domain.toType(context), this.range.toType(context));
    }

    static Type toEffect(TypeTranslationContext context, TypeAst[] effects) {
        if (effects.length == 0) {
            return Types.NO_EFFECTS;
        }
        if (effects.length == 1) {
            return effects[0].toEffect(context);
        }
        Type[] types = new Type[effects.length];
        int i = 0;
        while (i < effects.length) {
            types[i] = effects[i].toEffect(context);
            ++i;
        }
        return Types.union(types);
    }

    static Type toEffect(TypeElaborationContext context, TypeAst[] effects) {
        if (effects.length == 0) {
            return Types.NO_EFFECTS;
        }
        if (effects.length == 1) {
            return effects[0].toEffect(context);
        }
        Type[] types = new Type[effects.length];
        int i = 0;
        while (i < effects.length) {
            types[i] = effects[i].toEffect(context);
            ++i;
        }
        return Types.union(types);
    }

    @Override
    public int getPrecedence() {
        return 2;
    }

    @Override
    public void collectReferences(TObjectIntHashMap<String> typeNameMap, TIntHashSet set) {
        this.domain.collectReferences(typeNameMap, set);
        this.range.collectReferences(typeNameMap, set);
    }
}

