/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.parsing.declarations;

import java.util.ArrayList;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EIntegerLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ERealLiteral;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.QConjunction;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.relations.ConcreteRelation;
import org.simantics.scl.compiler.internal.parsing.declarations.DAnnotationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DDocumentationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DeclarationAst;

public class DRelationAst
extends DeclarationAst {
    public final Expression lhs;
    public final Object[] queries;
    public DDocumentationAst documentation;

    public DRelationAst(Expression lhs, Object[] queries) {
        this.lhs = lhs;
        this.queries = queries;
    }

    @Override
    public void toString(int indentation, StringBuilder b) {
        int i = 0;
        while (i < indentation) {
            b.append("    ");
            ++i;
        }
        b.append(this.lhs);
        b.append(" :-");
        Object[] objectArray = this.queries;
        int n = this.queries.length;
        int n2 = 0;
        while (n2 < n) {
            Object query = objectArray[n2];
            b.append('\n');
            int i2 = 0;
            while (i2 <= indentation) {
                b.append("    ");
                ++i2;
            }
            System.out.println(query);
            ++n2;
        }
    }

    @Override
    public void toString(StringBuilder b) {
        this.toString(0, b);
    }

    public void setLocationDeep(long der) {
        this.lhs.setLocationDeep(der);
        Object[] objectArray = this.queries;
        int n = this.queries.length;
        int n2 = 0;
        while (n2 < n) {
            Object query = objectArray[n2];
            if (query instanceof Query) {
                ((Query)query).setLocationDeep(der);
            }
            ++n2;
        }
    }

    public void translateTo(TranslationContext context, ConcreteRelation relation) {
        EApply apply = (EApply)this.lhs;
        Expression[] applyParameters = apply.getParameters();
        relation.parameters = new Variable[applyParameters.length];
        int i = 0;
        while (i < applyParameters.length) {
            Variable variable;
            EVar var = (EVar)applyParameters[i];
            relation.parameters[i] = variable = context.newVariable(var.name);
            ++i;
        }
        ArrayList<Query> ql = new ArrayList<Query>();
        DAnnotationAst annotation = null;
        Object[] objectArray = this.queries;
        int n = this.queries.length;
        int n2 = 0;
        while (n2 < n) {
            Object statement = objectArray[n2];
            if (statement instanceof DAnnotationAst) {
                if (!ql.isEmpty()) {
                    this.translateSection(context, annotation, ql, relation);
                    ql.clear();
                }
                annotation = (DAnnotationAst)statement;
            } else {
                ql.add((Query)statement);
            }
            ++n2;
        }
        if (!ql.isEmpty()) {
            this.translateSection(context, annotation, ql, relation);
        }
    }

    private void translateSection(TranslationContext context, DAnnotationAst annotation, ArrayList<Query> queries, ConcreteRelation relation) {
        Query query = queries.size() == 1 ? queries.get(0) : new QConjunction(queries);
        String sectionName = annotation.id.text.substring(1);
        if (sectionName.equals("enforce")) {
            relation.enforceSection = query.resolve(context);
            if (annotation.parameters.length > 0) {
                relation.phase = Integer.parseInt(((EIntegerLiteral)annotation.parameters[0]).getValue());
            }
            return;
        }
        int pattern = 0;
        int i = 0;
        while (i < sectionName.length()) {
            char c = sectionName.charAt(i);
            if (c == 'b') {
                pattern |= 1 << i;
            } else if (c != 'f') {
                context.getErrorLog().log(annotation.location, "Invalid section name '" + sectionName + "'.");
                return;
            }
            ++i;
        }
        if (relation.getSection(pattern) != null) {
            context.getErrorLog().log(annotation.location, "Query section is redundant because the previous sections cover it.");
        }
        double selectivity = 10.0;
        if (annotation.parameters.length > 0) {
            Expression selExp = annotation.parameters[0];
            selectivity = selExp instanceof ERealLiteral ? Double.parseDouble(((ERealLiteral)selExp).getValue()) : (double)Integer.parseInt(((EIntegerLiteral)selExp).getValue());
        }
        context.pushExistentialFrame();
        Query resolvedQuery = query.resolve(context);
        Variable[] existentials = context.popExistentialFrame();
        relation.addSection(pattern, selectivity, existentials, resolvedQuery);
    }
}

