/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.interpreted;

import java.util.Arrays;
import org.simantics.scl.compiler.internal.interpreted.IExpression;

public class IListLiteral
implements IExpression {
    private final IExpression[] componentExpressions;

    public IListLiteral(IExpression[] componentExpressions) {
        this.componentExpressions = componentExpressions;
    }

    @Override
    public Object execute(Object[] variableBindings) {
        Object[] components = new Object[this.componentExpressions.length];
        int i = 0;
        while (i < this.componentExpressions.length) {
            components[i] = this.componentExpressions[i].execute(variableBindings);
            ++i;
        }
        return Arrays.asList(components);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (i < this.componentExpressions.length) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.componentExpressions[i]);
            ++i;
        }
        b.append(']');
        return b.toString();
    }
}

