/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.subsumption2;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.elaboration.subsumption.Subsumption;
import org.simantics.scl.compiler.internal.elaboration.subsumption2.SubsumptionGraph;
import org.simantics.scl.compiler.internal.types.effects.EffectIdMap;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.util.Polarity;

public class SubSolver2 {
    public static final boolean DEBUG = false;
    private final ErrorLog errorLog;
    private final ArrayList<Subsumption> subsumptions;
    private final EffectIdMap effectIds = new EffectIdMap();
    private final THashMap<TMetaVar, SubsumptionGraph.VarNode> varNodeMap = new THashMap();
    private final ArrayList<SubsumptionGraph.UnionNode> unionNodes = new ArrayList();
    private static TIntIntHashMap STATISTICS = new TIntIntHashMap();
    THashSet<SubsumptionGraph.Node> set = new THashSet();
    private final THashSet<SubsumptionGraph.Node> activeSet = new THashSet();
    private final ArrayDeque<SubsumptionGraph.Node> queue = new ArrayDeque();
    int curIndex;
    ArrayList<SubsumptionGraph.VarNode> sortedNodes;
    ArrayList<SubsumptionGraph.VarNode> stack = new ArrayList();

    private SubSolver2(ErrorLog errorLog, ArrayList<Subsumption> subsumptions) {
        this.errorLog = errorLog;
        this.subsumptions = subsumptions;
    }

    public static void showStatistics() {
        int key;
        System.out.println("---");
        int[] keys = STATISTICS.keys();
        Arrays.sort(keys);
        int sum = 0;
        int[] nArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            key = nArray[n2];
            sum += STATISTICS.get(key);
            ++n2;
        }
        nArray = keys;
        n = keys.length;
        n2 = 0;
        while (n2 < n) {
            key = nArray[n2];
            int value = STATISTICS.get(key);
            System.out.println(key + ": " + value + " (" + (double)value * 100.0 / (double)sum + "%)");
            ++n2;
        }
    }

    private static boolean subsumes(int a, int b) {
        return (a & b) == a;
    }

    private void processSubsumptions() {
        ArrayList<TMetaVar> aVars = new ArrayList<TMetaVar>(2);
        ArrayList<TMetaVar> bVars = new ArrayList<TMetaVar>(2);
        for (Subsumption subsumption : this.subsumptions) {
            int aCons = this.effectIds.toId(subsumption.a, aVars);
            int bCons = this.effectIds.toId(subsumption.b, bVars);
            if (bVars.isEmpty()) {
                if (!SubSolver2.subsumes(aCons, bCons)) {
                    this.reportSubsumptionFailure(subsumption.loc, aCons, bCons);
                    continue;
                }
                for (TMetaVar aVar : aVars) {
                    this.getOrCreateNode((TMetaVar)aVar).upperBound &= bCons;
                }
            } else {
                SubsumptionGraph.Node bNode = bVars.size() == 1 && bCons == 0 ? this.getOrCreateNode(bVars.get(0)) : this.createUnion(subsumption.loc, bCons, bVars);
                if (aCons != 0) {
                    this.setLowerBound(subsumption.loc, aCons, bNode);
                }
                for (TMetaVar aVar : aVars) {
                    new SubsumptionGraph.Sub(this.getOrCreateNode(aVar), bNode);
                }
                bVars.clear();
            }
            aVars.clear();
        }
    }

    private void setLowerBound(long location, int lower, SubsumptionGraph.Node node) {
        node.lowerBound |= lower;
        node.addLowerBoundSource(location, lower);
    }

    private SubsumptionGraph.UnionNode createUnion(long location, int cons, ArrayList<TMetaVar> vars) {
        SubsumptionGraph.UnionNode node = new SubsumptionGraph.UnionNode(location, cons);
        for (TMetaVar var : vars) {
            new SubsumptionGraph.PartOfUnion(this.getOrCreateNode(var), node);
        }
        this.unionNodes.add(node);
        return node;
    }

    private SubsumptionGraph.VarNode getOrCreateNode(TMetaVar var) {
        SubsumptionGraph.VarNode node = (SubsumptionGraph.VarNode)this.varNodeMap.get((Object)var);
        if (node == null) {
            node = new SubsumptionGraph.VarNode(var);
            this.varNodeMap.put((Object)var, (Object)node);
        }
        return node;
    }

    public boolean solve() {
        int errorCount = this.errorLog.getErrorCount();
        this.processSubsumptions();
        this.propagateUpperBounds();
        this.checkLowerBounds();
        if (this.errorLog.getErrorCount() != errorCount) {
            return false;
        }
        this.stronglyConnectedComponents();
        this.propagateLowerBounds();
        this.simplify();
        return true;
    }

    private void touchNeighborhood(SubsumptionGraph.VarNode node) {
        Object cur = node.lower;
        while (cur != null) {
            this.touch(((SubsumptionGraph.Sub)cur).a);
            cur = ((SubsumptionGraph.Sub)cur).bNext;
        }
        cur = node.upper;
        while (cur != null) {
            this.touch(((SubsumptionGraph.Sub)cur).b);
            cur = ((SubsumptionGraph.Sub)cur).aNext;
        }
        cur = node.partOf;
        while (cur != null) {
            this.touch(((SubsumptionGraph.PartOfUnion)cur).b);
            cur = ((SubsumptionGraph.PartOfUnion)cur).aNext;
        }
    }

    private void touchNeighborhood(SubsumptionGraph.UnionNode node) {
        Object cur = node.lower;
        while (cur != null) {
            this.touch(((SubsumptionGraph.Sub)cur).a);
            cur = ((SubsumptionGraph.Sub)cur).bNext;
        }
        cur = node.parts;
        while (cur != null) {
            this.touch(((SubsumptionGraph.PartOfUnion)cur).a);
            cur = ((SubsumptionGraph.PartOfUnion)cur).bNext;
        }
    }

    private void simplify() {
        for (SubsumptionGraph.VarNode varNode : this.sortedNodes) {
            if (varNode.index == 0x7FFFFFFE) continue;
            this.activeSet.add((Object)varNode);
            this.queue.addLast(varNode);
        }
        for (SubsumptionGraph.UnionNode unionNode : this.unionNodes) {
            if (unionNode.constPart == 0x7FFFFFFE) continue;
            this.activeSet.add((Object)unionNode);
            this.queue.addLast(unionNode);
        }
        while (!this.queue.isEmpty()) {
            SubsumptionGraph.Node node = this.queue.removeFirst();
            this.activeSet.remove((Object)node);
            if (node instanceof SubsumptionGraph.VarNode) {
                Polarity polarity;
                SubsumptionGraph.VarNode node2 = (SubsumptionGraph.VarNode)node;
                if (node2.index == 0x7FFFFFFE) continue;
                if (node2.lowerBound == node2.upperBound) {
                    this.touchNeighborhood(node2);
                    node2.removeConstantNode(this.effectIds, node2.lowerBound);
                    continue;
                }
                SubsumptionGraph.Sub cur = node2.upper;
                while (cur != null) {
                    if (cur.b == node2) {
                        cur.remove();
                    }
                    cur = cur.aNext;
                }
                if (node2.upper != null && node2.upper.aNext != null) {
                    cur = node2.upper;
                    while (cur != null) {
                        if (!this.set.add((Object)cur.b) || SubSolver2.subsumes(node2.upperBound, cur.a.lowerBound)) {
                            this.touch(cur.b);
                            cur.remove();
                        }
                        cur = cur.aNext;
                    }
                    this.set.clear();
                }
                if (node2.lower != null && node2.lower.bNext != null) {
                    cur = node2.lower;
                    while (cur != null) {
                        if (!this.set.add((Object)cur.a) || SubSolver2.subsumes(cur.a.upperBound, node2.lowerBound)) {
                            this.touch(cur.a);
                            cur.remove();
                        }
                        cur = cur.bNext;
                    }
                    this.set.clear();
                }
                if (!(polarity = node2.getPolarity()).isNegative()) {
                    if (node2.partOf != null) continue;
                    if (node2.lower == null) {
                        this.touchNeighborhood(node2);
                        node2.removeConstantNode(this.effectIds, node2.lowerBound);
                        continue;
                    }
                    if (node2.lower.bNext != null) continue;
                    SubsumptionGraph.VarNode low = node2.lower.a;
                    if (low.lowerBound != node2.lowerBound) continue;
                    node2.lower.remove();
                    this.touchNeighborhood(node2);
                    node2.replaceBy(low);
                    continue;
                }
                if (polarity != Polarity.NEGATIVE || node2.upper == null || node2.upper.aNext != null) continue;
                SubsumptionGraph.Node high = node2.upper.b;
                if (node2.upperBound != high.upperBound || !(high instanceof SubsumptionGraph.VarNode)) continue;
                SubsumptionGraph.VarNode varHigh = (SubsumptionGraph.VarNode)high;
                node2.upper.remove();
                this.touchNeighborhood(node2);
                node2.replaceBy(varHigh);
                continue;
            }
            SubsumptionGraph.UnionNode union = (SubsumptionGraph.UnionNode)node;
            if (union.constPart == 0x7FFFFFFE) continue;
            if (union.lower == null) {
                int low = union.constPart;
                SubsumptionGraph.PartOfUnion partOf = union.parts;
                while (partOf != null) {
                    low |= partOf.a.lowerBound;
                    partOf = partOf.bNext;
                }
                if (!SubSolver2.subsumes(union.lowerBound, low)) continue;
                this.touchNeighborhood(union);
                union.remove();
                continue;
            }
            SubsumptionGraph.Sub cur = union.lower;
            while (cur != null) {
                SubsumptionGraph.VarNode lowNode = union.lower.a;
                SubsumptionGraph.PartOfUnion partOf = union.parts;
                while (partOf != null) {
                    if (partOf.a == lowNode) {
                        cur.remove();
                        this.touch(union);
                        break;
                    }
                    partOf = partOf.bNext;
                }
                cur = cur.bNext;
            }
        }
    }

    private void checkLowerBounds() {
        for (SubsumptionGraph.VarNode varNode : this.varNodeMap.values()) {
            this.checkLowerBound(varNode);
        }
        for (SubsumptionGraph.UnionNode unionNode : this.unionNodes) {
            this.checkLowerBound(unionNode);
        }
    }

    private void checkLowerBound(SubsumptionGraph.Node node) {
        int upperBound = node.upperBound;
        if (!SubSolver2.subsumes(node.lowerBound, upperBound)) {
            SubsumptionGraph.LowerBoundSource source = node.lowerBoundSource;
            while (source != null) {
                if (!SubSolver2.subsumes(source.lower, upperBound)) {
                    this.reportSubsumptionFailure(source.location, source.lower, upperBound);
                }
                source = source.next;
            }
        }
        node.lowerBoundSource = null;
    }

    private void propagateLowerBounds() {
        SubsumptionGraph.Sub cur;
        for (SubsumptionGraph.VarNode varNode : this.sortedNodes) {
            cur = varNode.lower;
            while (cur != null) {
                varNode.lowerBound |= cur.a.lowerBound;
                cur = cur.bNext;
            }
        }
        if (!this.unionNodes.isEmpty()) {
            for (SubsumptionGraph.UnionNode unionNode : this.unionNodes) {
                if (unionNode.parts != null && unionNode.parts.bNext != null) {
                    THashSet varSet = new THashSet();
                    SubsumptionGraph.PartOfUnion cur2 = unionNode.parts;
                    while (cur2 != null) {
                        if (!varSet.add((Object)cur2.a)) {
                            cur2.remove();
                        }
                        cur2 = cur2.bNext;
                    }
                }
                cur = unionNode.lower;
                while (cur != null) {
                    unionNode.lowerBound |= cur.a.lowerBound;
                    cur = cur.bNext;
                }
                this.activeSet.add((Object)unionNode);
                this.queue.addLast(unionNode);
            }
            while (!this.queue.isEmpty()) {
                Object cur2;
                SubsumptionGraph.Node node = this.queue.removeFirst();
                this.activeSet.remove((Object)node);
                int lowerBound = node.lowerBound;
                if (node instanceof SubsumptionGraph.VarNode) {
                    SubsumptionGraph.VarNode var = (SubsumptionGraph.VarNode)node;
                    cur2 = var.upper;
                    while (cur2 != null) {
                        SubsumptionGraph.Node highNode = ((SubsumptionGraph.Sub)cur2).b;
                        int newLowerBound = highNode.lowerBound & lowerBound;
                        if (newLowerBound != highNode.lowerBound) {
                            highNode.lowerBound = newLowerBound;
                            this.touch(highNode);
                        }
                        cur2 = ((SubsumptionGraph.Sub)cur2).aNext;
                    }
                    continue;
                }
                SubsumptionGraph.UnionNode union = (SubsumptionGraph.UnionNode)node;
                cur2 = union.parts;
                while (cur2 != null) {
                    int residual = lowerBound & ~union.constPart;
                    SubsumptionGraph.PartOfUnion cur22 = union.parts;
                    while (cur22 != null) {
                        if (cur22 != cur2) {
                            residual = lowerBound & ~cur22.a.upperBound;
                        }
                        cur22 = cur22.bNext;
                    }
                    SubsumptionGraph.VarNode partNode = ((SubsumptionGraph.PartOfUnion)cur2).a;
                    int newLowerBound = partNode.lowerBound | residual;
                    if (newLowerBound != partNode.lowerBound) {
                        partNode.lowerBound = newLowerBound;
                        this.touch(partNode);
                    }
                    cur2 = ((SubsumptionGraph.PartOfUnion)cur2).bNext;
                }
            }
        }
    }

    private void reportSubsumptionFailure(long location, int lowerBound, int upperBound) {
        this.errorLog.log(location, "Side-effect " + String.valueOf(this.effectIds.toType(lowerBound & ~upperBound)) + " is forbidden here.");
    }

    private void touch(SubsumptionGraph.Node node) {
        if (this.activeSet.add((Object)node)) {
            this.queue.addLast(node);
        }
    }

    private void propagateUpperBounds() {
        for (SubsumptionGraph.Node node : this.varNodeMap.values()) {
            if (node.upperBound == -1) continue;
            this.activeSet.add((Object)node);
            this.queue.addLast(node);
        }
        while (!this.queue.isEmpty()) {
            Object cur;
            SubsumptionGraph.Node node;
            node = this.queue.removeFirst();
            this.activeSet.remove((Object)node);
            int upperBound = node.upperBound;
            if (node instanceof SubsumptionGraph.VarNode) {
                cur = node.partOf;
                while (cur != null) {
                    SubsumptionGraph.UnionNode union = ((SubsumptionGraph.PartOfUnion)cur).b;
                    this.touch(union);
                    cur = ((SubsumptionGraph.PartOfUnion)cur).aNext;
                }
            } else {
                SubsumptionGraph.UnionNode union = (SubsumptionGraph.UnionNode)node;
                int newUpperBound = union.constPart;
                SubsumptionGraph.PartOfUnion cur2 = union.parts;
                while (cur2 != null) {
                    newUpperBound |= cur2.a.upperBound;
                    cur2 = cur2.bNext;
                }
                if (newUpperBound == upperBound) continue;
                node.upperBound = upperBound = newUpperBound;
            }
            cur = node.lower;
            while (cur != null) {
                SubsumptionGraph.VarNode lowNode = ((SubsumptionGraph.Sub)cur).a;
                int newUpperBound = lowNode.upperBound & upperBound;
                if (newUpperBound != lowNode.upperBound) {
                    lowNode.upperBound = newUpperBound;
                    this.touch(lowNode);
                }
                cur = ((SubsumptionGraph.Sub)cur).bNext;
            }
        }
    }

    private void stronglyConnectedComponents() {
        this.sortedNodes = new ArrayList(this.varNodeMap.size());
        for (SubsumptionGraph.VarNode node : this.varNodeMap.values()) {
            node.index = -1;
        }
        for (SubsumptionGraph.VarNode node : this.varNodeMap.values()) {
            if (node.index != -1) continue;
            this.curIndex = 0;
            this.stronglyConnectedComponents(node);
        }
    }

    private int stronglyConnectedComponents(SubsumptionGraph.VarNode node) {
        node.index = this.curIndex++;
        int lowindex = node.index;
        this.stack.add(node);
        SubsumptionGraph.Sub sub = node.lower;
        while (sub != null) {
            SubsumptionGraph.VarNode child = sub.a;
            int childIndex = child.index;
            if (childIndex == -1) {
                childIndex = this.stronglyConnectedComponents(child);
            }
            lowindex = Math.min(lowindex, childIndex);
            sub = sub.bNext;
        }
        if (node.index == lowindex) {
            SubsumptionGraph.VarNode stackNode = this.stack.remove(this.stack.size() - 1);
            if (stackNode != node) {
                ArrayList<SubsumptionGraph.VarNode> otherInComponent = new ArrayList<SubsumptionGraph.VarNode>(4);
                while (stackNode != node) {
                    otherInComponent.add(stackNode);
                    stackNode = this.stack.remove(this.stack.size() - 1);
                }
                this.mergeComponent(node, otherInComponent);
            }
            node.index = Integer.MAX_VALUE;
            this.sortedNodes.add(node);
        }
        return lowindex;
    }

    private void mergeComponent(SubsumptionGraph.VarNode root, ArrayList<SubsumptionGraph.VarNode> otherInComponent) {
        int lowerBound = root.lowerBound;
        for (SubsumptionGraph.VarNode node : otherInComponent) {
            lowerBound |= node.lowerBound;
        }
        root.lowerBound = lowerBound;
        for (SubsumptionGraph.VarNode node : otherInComponent) {
            node.replaceBy(root);
        }
    }

    private String toName(SubsumptionGraph.Node node) {
        return "";
    }

    private void printUnion(SubsumptionGraph.UnionNode union) {
    }

    private void print() {
    }

    private String constToString(int cons) {
        return "";
    }

    public static void solve(ErrorLog errorLog, ArrayList<Subsumption> subsumptions) {
        new SubSolver2(errorLog, subsumptions).solve();
    }
}

