/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.subsumption;

import java.util.ArrayList;
import org.simantics.scl.compiler.internal.elaboration.subsumption.Var;

public class VUnion {
    Var low;
    int con;
    ArrayList<Var> vars;

    public VUnion(int con, ArrayList<Var> vars) {
        this.con = con;
        this.vars = vars;
    }

    public void removeVar(Var var) {
        if (this.vars.remove(var)) {
            var.complexLowerBounds.remove(this);
            var.markDirty();
        }
    }

    public void addVar(Var var) {
        if (!this.vars.contains(var)) {
            this.vars.add(var);
            var.complexLowerBounds.add(this);
            var.markDirty();
        }
    }

    public void makeLowerBound(int low) {
        this.con |= ~low;
        if (this.vars.size() == 1) {
            this.vars.get(0).addLowerBound(~this.con);
        } else {
            for (Var v : this.vars) {
                v.complexLowerBounds.add(this);
            }
        }
    }

    public int getUpperApprox() {
        int cur = this.con;
        for (Var v : this.vars) {
            cur |= v.upperApprox;
        }
        return cur;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        if (this.con > 0) {
            b.append(this.con);
            first = false;
        }
        for (Var v : this.vars) {
            if (first) {
                first = false;
            } else {
                b.append(" + ");
            }
            b.append(v.name);
        }
        return b.toString();
    }
}

